% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_and_rephase.R
\name{split_and_rephase}
\alias{split_and_rephase}
\title{Divides map in sub-maps and re-phase them}
\usage{
split_and_rephase(
  input.map,
  twopt,
  gap.threshold = 5,
  remove.single = TRUE,
  phase.config = "best",
  tol.final = 0.001,
  verbose = TRUE
)
}
\arguments{
\item{input.map}{an object of class \code{mappoly.map}}

\item{twopt}{an object of class \code{poly.est.two.pts.pairwise}
containing the two-point information for the markers contained 
in \code{input.map}}

\item{gap.threshold}{distance threshold of neighboring markers 
where the map should be spitted. The default 
value is 5 cM}

\item{remove.single}{Should isolated markers be removed?}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the phase configuration associated with the
maximum likelihood}

\item{tol.final}{the desired accuracy for the final map (default = 10e-04)}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class \code{mappoly.map}
}
\description{
The function splits the input map in sub-maps 
given a distance threshold of neighboring markers 
and evaluates alternative phases between the sub-maps.
}
\examples{
 map <- get_submap(maps.hexafake[[1]], 1:20, reestimate.rf = FALSE, reestimate.phase = FALSE)
 tpt <- est_pairwise_rf(make_seq_mappoly(map))
 new.map <- split_and_rephase(map, tpt, 5)
 map
 new.map
 plot_map_list(list(old.map = map, new.map = new.map))

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
