% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_segregation}
\alias{filter_segregation}
\title{Filter markers based on chi-square test}
\usage{
filter_segregation(input.data, chisq.pval.thres = NULL, inter = TRUE)
}
\arguments{
\item{input.data}{name of input object (class \code{mappoly.data})}

\item{chisq.pval.thres}{p-value threshold used for chi-square tests 
(default = Bonferroni aproximation with global alpha of 0.05, i.e., 
0.05/n.mrk)}

\item{inter}{if TRUE (default), plots distorted vs. non-distorted markers}
}
\value{
An object of class \code{mappoly.chitest.seq} which contains a list with the following components:
\item{keep}{markers that follow Mendelian segregation pattern}
\item{exclude}{markers with distorted segregation}
\item{chisq.pval.thres}{threshold p-value used for chi-square tests}
\item{data.name}{input dataset used to perform the chi-square tests}
}
\description{
This function filter markers based on p-values of a chi-square test. 
The chi-square test assumes that markers follow the expected segregation
 patterns under Mendelian inheritance, random chromosome bivalent 
 pairing and no double reduction.
}
\examples{
mrks.chi.filt <- filter_segregation(input.data = tetra.solcap,
                                    chisq.pval.thres = 0.05/tetra.solcap$n.mrk,
                                    inter = TRUE)
seq.init <- make_seq_mappoly(mrks.chi.filt)

}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
