% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggplot.R
\name{map_ggplot}
\alias{map_ggplot}
\title{ggplot2 mapping}
\usage{
map_ggplot(x, map = "world", point_color = "#86161f", lon = "longitude",
  lat = "latitude", ...)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{SpatialPoints}, \code{SpatialPointsDataFrame}, or
\code{data.frame}. The package \pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{map}{(character) One of world, world2, state, usa, county, france, italy, or nz}

\item{point_color}{Default color of your points}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess, but
if nothing close, we stop. Default: \code{longitude} and \code{latitude}}

\item{...}{Ignored}
}
\value{
A ggplot2 map, of class \code{gg/ggplot}
}
\description{
ggplot2 mapping
}
\examples{
\dontrun{
## spocc
library("spocc")
dat <- occ(query = 'Lynx rufus californicus', from = 'gbif', limit=100)
map_ggplot(dat)
map_ggplot(dat$gbif)
map_ggplot(dat, "usa")
map_ggplot(dat, "county")

### usage of occ2sp()
#### SpatialPoints
spdat <- occ2sp(dat)
map_ggplot(spdat)
#### SpatialPointsDataFrame
spdatdf <- as(spdat, "SpatialPointsDataFrame")
map_ggplot(spdatdf)

## rgbif
library("rgbif")
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_ggplot(res)

## data.frame
df <- data.frame(name = c('Poa annua', 'Puma concolor', 'Foo bar'),
                 longitude = c(-120, -121, -121),
                 latitude = c(41, 42, 45), stringsAsFactors = FALSE)
map_ggplot(df)
}
}

