% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_get_segments.R
\name{mp_get_segments}
\alias{mp_get_segments}
\title{Extract *route segments* from a Google Maps Directions API response}
\usage{
mp_get_segments(doc)
}
\arguments{
\item{doc}{XML document with Google Maps Directions API response}
}
\value{
Line layer (class \code{sf}) representing route segments
}
\description{
Extract *route segments* from a Google Maps Directions API response
}
\examples{
library(xml2)
doc = as_xml_document(response_directions_driving)
seg = mp_get_segments(doc)
plot(seg)
doc = as_xml_document(response_directions_transit)
seg = mp_get_segments(doc)
plot(seg)
\dontrun{
# Transit example
doc = mp_directions(
  origin = c(34.81127, 31.89277),
  destination = c(34.781107, 32.085003),
  mode = "transit",
  alternatives = TRUE,
)
seg = mp_get_segments(doc)
}
}
