% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_theme.R
\name{mf_theme}
\alias{mf_theme}
\title{Set a theme}
\usage{
mf_theme(x, bg, fg, mar, tab, pos, inner, line, cex, font)
}
\arguments{
\item{x}{name of a map theme. One of "default", "brutal", "ink",
"dark", "agolalight", "candy", "darkula", "iceberg", "green", "nevermind",
"jsk", "barcelona".}

\item{bg}{background color}

\item{fg}{foreground color}

\item{mar}{margins}

\item{tab}{if TRUE the title is displayed as a 'tab'}

\item{pos}{title position, one of 'left', 'center', 'right'}

\item{inner}{if TRUE the title is displayed inside the plot area.}

\item{line}{number of lines used for the title}

\item{cex}{cex of the title}

\item{font}{font of the title}
}
\value{
The (invisible) list of theme parameters is returned.
}
\description{
This function set a map theme.
The parameters set by this function are the figure margins, background and
foreground colors and some \link{mf_title} options.
Use \code{mf_theme(NULL)} or \code{mf_theme('default')} to reset to default
theme settings.
}
\details{
It is also possible to set a custom theme using a list of arguments
(see Examples).
\code{mf_theme()} returns the current theme settings.
}
\examples{
mtq <- mf_get_mtq()

# Choosing a theme by name:
mf_theme("default")
mf_map(mtq)
mf_title()

# Specifying some values directly:
mf_theme(bg = "darkslategrey", fg = "lightgrey")
mf_map(mtq)
mf_title()

# Using a mix of the above:
mf_theme("brutal", fg = "lightgreen", pos = "center", font = 2, tab = FALSE)
mf_map(mtq)
mf_title()

# Specifying a list with theme values:
theme <- mf_theme("default")
theme$mar <- c(1, 1, 3, 1)
theme$line <- 2
theme$cex <- 1.5
mf_theme(theme)
mf_map(mtq)
mf_title()

# or
theme <- list(
  bg = "green",
  fg = "red",
  mar = c(2, 2, 2, 2),
  tab = TRUE,
  pos = "center",
  inner = TRUE,
  line = 2,
  cex = 1.5,
  font = 3
)
mf_theme(theme)
mf_map(mtq)
mf_title()

# Obtaining a list of parameters for the current theme:
mf_theme()

# Removing the current theme:
mf_theme(NULL)
# or
mf_theme("default")
}
