% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_typo.R
\name{mf_typo}
\alias{mf_typo}
\title{Plot a typology map}
\usage{
mf_typo(
  x,
  var,
  pal = "Dynamic",
  alpha = 1,
  val_order,
  border,
  pch = 21,
  cex = 1,
  lwd = 0.7,
  cex_na = 1,
  pch_na = 4,
  col_na = "white",
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_no_data = "No data",
  leg_frame = FALSE,
  add = FALSE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{if \code{pal} is a \link{hcl.colors} palette name, the alpha-transparency level in the range [0,1]}

\item{val_order}{values order, a character vector that matches var modalities}

\item{border}{border color}

\item{pch}{pch type of pch if x is a POINT layer}

\item{cex}{cex cex of the symbols if x is a POINT layer}

\item{lwd}{border width}

\item{cex_na}{cex for NA values if x is a POINT layer}

\item{pch_na}{pch for NA values if x is a POINT layer}

\item{col_na}{color for missing values}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
No return value, a map is displayed.
}
\description{
Plot a typology map.
}
\examples{
mtq <- mf_get_mtq()
mf_typo(mtq, "STATUS")
mtq[6, "STATUS"] <- NA
mf_typo(
  x = mtq, var = "STATUS", pal = c("red", "blue", "yellow"), lwd = 1.1,
  val_order = c("Prefecture", "Sub-prefecture", "Simple municipality"),
  col_na = "green", border = "brown",
  leg_pos = "bottomleft",
  leg_title = "Status", leg_title_cex = 1.1,
  leg_val_cex = 1, leg_no_data = "No data",
  leg_frame = TRUE, add = FALSE
)
}
\keyword{internal}
