% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapView.R
\docType{methods}
\name{mapView}
\alias{mapView}
\alias{mapView,RasterLayer-method}
\alias{mapView,stars-method}
\alias{mapView,stars_proxy-method}
\alias{mapView,SpatRaster-method}
\alias{mapView,RasterStackBrick-method}
\alias{mapView,Satellite-method}
\alias{mapView,sf-method}
\alias{mapView,SpatVector-method}
\alias{mapView,sfc-method}
\alias{mapView,character-method}
\alias{mapView,numeric-method}
\alias{mapView,data.frame-method}
\alias{mapView,XY-method}
\alias{mapView,XYZ-method}
\alias{mapView,XYM-method}
\alias{mapView,XYZM-method}
\alias{mapView,bbox-method}
\alias{mapView,missing-method}
\alias{mapView,NULL-method}
\alias{mapView,list-method}
\alias{mapview,ANY-method}
\alias{mapview}
\alias{mapView,SpatialPixelsDataFrame-method}
\alias{mapView,SpatialGridDataFrame-method}
\alias{mapView,SpatialPointsDataFrame-method}
\alias{mapView,SpatialPoints-method}
\alias{mapView,SpatialPolygonsDataFrame-method}
\alias{mapView,SpatialPolygons-method}
\alias{mapView,SpatialLinesDataFrame-method}
\alias{mapView,SpatialLines-method}
\title{View spatial objects interactively}
\usage{
\S4method{mapView}{RasterLayer}(
  x,
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = mapviewGetOption("use.layer.names"),
  map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = mapviewGetOption("trim"),
  verbose = mapviewGetOption("verbose"),
  layer.name = NULL,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = mapviewGetOption("native.crs"),
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = mapviewGetOption("query.type"),
  query.digits = mapviewGetOption("query.digits"),
  query.position = mapviewGetOption("query.position"),
  query.prefix = mapviewGetOption("query.prefix"),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  hide = FALSE,
  ...
)

\S4method{mapView}{stars}(
  x,
  band = 1,
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = mapviewGetOption("use.layer.names"),
  map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = mapviewGetOption("trim"),
  verbose = mapviewGetOption("verbose"),
  layer.name = NULL,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = mapviewGetOption("native.crs"),
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = mapviewGetOption("query.type"),
  query.digits = mapviewGetOption("query.digits"),
  query.position = mapviewGetOption("query.position"),
  query.prefix = mapviewGetOption("query.prefix"),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  pane = "auto",
  hide = FALSE,
  ...
)

\S4method{mapView}{stars_proxy}(
  x,
  band = 1,
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = mapviewGetOption("use.layer.names"),
  map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = mapviewGetOption("trim"),
  verbose = mapviewGetOption("verbose"),
  layer.name = NULL,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = mapviewGetOption("native.crs"),
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = mapviewGetOption("query.type"),
  query.digits = mapviewGetOption("query.digits"),
  query.position = mapviewGetOption("query.position"),
  query.prefix = mapviewGetOption("query.prefix"),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  pane = "auto",
  hide = FALSE,
  ...
)

\S4method{mapView}{SpatRaster}(
  x,
  band = 1,
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = mapviewGetOption("use.layer.names"),
  map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = mapviewGetOption("trim"),
  verbose = mapviewGetOption("verbose"),
  layer.name = NULL,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = mapviewGetOption("native.crs"),
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = mapviewGetOption("query.type"),
  query.digits = mapviewGetOption("query.digits"),
  query.position = mapviewGetOption("query.position"),
  query.prefix = mapviewGetOption("query.prefix"),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  pane = "auto",
  hide = FALSE,
  ...
)

\S4method{mapView}{RasterStackBrick}(
  x,
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = TRUE,
  map.types = mapviewGetOption("basemaps"),
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = TRUE,
  verbose = mapviewGetOption("verbose"),
  homebutton = mapviewGetOption("homebutton"),
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = c("mousemove", "click"),
  query.digits = mapviewGetOption("query.digits"),
  query.position = mapviewGetOption("query.position"),
  query.prefix = "Layer",
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  hide = FALSE,
  ...
)

\S4method{mapView}{Satellite}(
  x,
  map = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  map.types = mapviewGetOption("basemaps"),
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = TRUE,
  verbose = mapviewGetOption("verbose"),
  homebutton = mapviewGetOption("homebutton"),
  method = c("bilinear", "ngb"),
  label = TRUE,
  hide = FALSE,
  ...
)

\S4method{mapView}{sf}(
  x,
  map = NULL,
  pane = "auto",
  canvas = useCanvas(x),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  zcol = NULL,
  burst = FALSE,
  color = mapviewGetOption("vector.palette"),
  col.regions = mapviewGetOption("vector.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  cex = 6,
  lwd = lineWidth(x),
  alpha = 0.9,
  alpha.regions = regionOpacity(x),
  na.alpha = regionOpacity(x),
  map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"),
  popup = TRUE,
  layer.name = NULL,
  label = zcol,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  highlight = mapviewHighlightOptions(x, alpha.regions, alpha, lwd),
  maxpoints = getMaxFeatures(x),
  hide = FALSE,
  ...
)

\S4method{mapView}{SpatVector}(
  x,
  map = NULL,
  pane = "auto",
  canvas = useCanvas(x),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  zcol = NULL,
  burst = FALSE,
  color = mapviewGetOption("vector.palette"),
  col.regions = mapviewGetOption("vector.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  cex = 6,
  lwd = lineWidth(x),
  alpha = 0.9,
  alpha.regions = regionOpacity(x),
  na.alpha = regionOpacity(x),
  map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"),
  popup = TRUE,
  layer.name = NULL,
  label = zcol,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  highlight = mapviewHighlightOptions(x, alpha.regions, alpha, lwd),
  maxpoints = getMaxFeatures(x),
  hide = FALSE,
  ...
)

\S4method{mapView}{sfc}(
  x,
  map = NULL,
  pane = "auto",
  canvas = useCanvas(x),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  color = standardColor(x),
  col.regions = standardColRegions(x),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  cex = 6,
  lwd = lineWidth(x),
  alpha = 0.9,
  alpha.regions = regionOpacity(x),
  map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"),
  popup = NULL,
  layer.name = deparse(substitute(x, env = parent.frame())),
  label = makeLabels(x),
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  highlight = mapviewHighlightOptions(x, alpha.regions, alpha, lwd),
  maxpoints = getMaxFeatures(x),
  hide = FALSE,
  ...
)

\S4method{mapView}{character}(
  x,
  map = NULL,
  tms = TRUE,
  color = standardColor(),
  col.regions = standardColRegions(),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  cex = 6,
  lwd = 2,
  alpha = 0.9,
  alpha.regions = 0.6,
  na.alpha = 0.6,
  map.types = mapviewGetOption("basemaps"),
  verbose = FALSE,
  layer.name = x,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  canvas = FALSE,
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  ...
)

\S4method{mapView}{numeric}(x, y, type = "p", grid = TRUE, label, ...)

\S4method{mapView}{data.frame}(
  x,
  xcol,
  ycol,
  grid = TRUE,
  aspect = 1,
  popup = leafpop::popupTable(x, className = "mapview-popup"),
  label,
  crs = NA,
  ...
)

\S4method{mapView}{XY}(
  x,
  map = NULL,
  pane = "auto",
  canvas = useCanvas(x),
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  color = standardColor(x),
  col.regions = standardColRegions(x),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  cex = 6,
  lwd = lineWidth(x),
  alpha = 0.9,
  alpha.regions = regionOpacity(x),
  map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"),
  popup = NULL,
  layer.name = deparse(substitute(x, env = parent.frame(1))),
  label = makeLabels(x),
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  highlight = mapviewHighlightOptions(x, alpha.regions, alpha, lwd),
  maxpoints = getMaxFeatures(x),
  hide = FALSE,
  ...
)

\S4method{mapView}{XYZ}(x, layer.name = deparse(substitute(x, env = parent.frame(1))), ...)

\S4method{mapView}{XYM}(x, layer.name = deparse(substitute(x, env = parent.frame(1))), ...)

\S4method{mapView}{XYZM}(x, layer.name = deparse(substitute(x, env = parent.frame(1))), ...)

\S4method{mapView}{bbox}(
  x,
  layer.name = deparse(substitute(x, env = parent.frame(1))),
  alpha.regions = 0.2,
  ...
)

\S4method{mapView}{missing}(map.types = mapviewGetOption("basemaps"), ...)

\S4method{mapView}{`NULL`}(x, ...)

\S4method{mapView}{list}(
  x,
  map = NULL,
  zcol = NULL,
  burst = FALSE,
  color = mapviewGetOption("vector.palette"),
  col.regions = mapviewGetOption("vector.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  cex = 6,
  lwd = lapply(x, lineWidth),
  alpha = 0.9,
  alpha.regions = lapply(x, regionOpacity),
  na.alpha = lapply(x, regionOpacity),
  map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"),
  popup = TRUE,
  layer.name = deparse(substitute(x, env = parent.frame())),
  label = lapply(x, makeLabels),
  legend = mapviewGetOption("legend"),
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  hide = FALSE,
  ...
)

\S4method{mapview}{ANY}(...)

\S4method{mapView}{SpatialPixelsDataFrame}(
  x,
  map = NULL,
  zcol = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = FALSE,
  map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = TRUE,
  verbose = mapviewGetOption("verbose"),
  layer.name = NULL,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = c("mousemove", "click"),
  query.digits,
  query.position = "topright",
  query.prefix = "Layer",
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  hide = FALSE,
  ...
)

\S4method{mapView}{SpatialGridDataFrame}(
  x,
  map = NULL,
  zcol = NULL,
  maxpixels = mapviewGetOption("mapview.maxpixels"),
  col.regions = mapviewGetOption("raster.palette"),
  at = NULL,
  na.color = mapviewGetOption("na.color"),
  use.layer.names = FALSE,
  map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8,
  legend = mapviewGetOption("legend"),
  legend.opacity = 1,
  trim = TRUE,
  verbose = mapviewGetOption("verbose"),
  layer.name = NULL,
  homebutton = mapviewGetOption("homebutton"),
  native.crs = FALSE,
  method = mapviewGetOption("method"),
  label = TRUE,
  query.type = c("mousemove", "click"),
  query.digits,
  query.position = "topright",
  query.prefix = "Layer",
  viewer.suppress = mapviewGetOption("viewer.suppress"),
  hide = FALSE,
  ...
)

\S4method{mapView}{SpatialPointsDataFrame}(x, zcol = NULL, layer.name = NULL, ...)

\S4method{mapView}{SpatialPoints}(x, zcol = NULL, layer.name = NULL, ...)

\S4method{mapView}{SpatialPolygonsDataFrame}(x, zcol = NULL, layer.name = NULL, ...)

\S4method{mapView}{SpatialPolygons}(x, zcol = NULL, layer.name = NULL, ...)

\S4method{mapView}{SpatialLinesDataFrame}(x, zcol = NULL, layer.name = NULL, ...)

\S4method{mapView}{SpatialLines}(x, zcol = NULL, layer.name = NULL, ...)
}
\arguments{
\item{x}{a \code{Raster*} or \code{Spatial*} or \code{Satellite} or
\code{sf} or \code{stars} object or a list of any combination of those. Furthermore,
  this can also be a \code{data.frame}, a \code{numeric vector} or a
\code{character string} pointing to a tile image folder or file on disk.
  If missing, a blank map will be drawn. A value of NULL will return NULL.}

\item{map}{an optional existing map to be updated/added to.}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{col.regions}{color (palette) pixels.
See \code{\link{levelplot}} for details.}

\item{at}{the breakpoints used for the visualisation.
See \code{\link{levelplot}} for details.}

\item{na.color}{color for missing values}

\item{use.layer.names}{should layer names of the Raster* object be used?}

\item{map.types}{character spcifications for the base maps.
see \url{https://leaflet-extras.github.io/leaflet-providers/preview/}
for available options.}

\item{alpha.regions}{opacity of the fills of points, polygons or raster layer(s)}

\item{legend}{should a legend be plotted}

\item{legend.opacity}{opacity of the legend}

\item{trim}{should the raster be trimmed in case there are NAs on the edges}

\item{verbose}{should some details be printed during the process}

\item{layer.name}{the name of the layer to be shown on the map.
By default this is the character version of whatever is passed to \code{x}.
NOTE: This is being passed to underlying leaflet functions as the group argument.
So if you use mapview to set up a map and want to refer to a certain layer
later on, this is what you should refer to in \code{group}.}

\item{homebutton}{logical, whether to add a zoom-to-layer button to the map.
Defaults to TRUE}

\item{native.crs}{logical whether to reproject to web map coordinate
reference system (web mercator - epsg:3857) or render using native CRS of
the supplied data (can also be NA). Default is FALSE which will render in
web mercator. If set to TRUE now background maps will be drawn (but rendering
may be much quicker as no reprojecting is necessary). Currently only works
for simple features.}

\item{method}{for raster data only (raster/stars). Method used to compute
values for the resampled layer that is passed on to leaflet. mapview does
projection on-the-fly to ensure correct display and therefore needs to know
how to do this projection. The default is 'bilinear' (bilinear interpolation),
which is appropriate for continuous variables. The other option, 'ngb'
(nearest neighbor), is useful for categorical variables. Ignored if the raster
layer is of class \code{factor} in which case "ngb" is used.}

\item{label}{For vector data (sf/sp) a character vector of labels to be
shown on mouseover. See \code{\link{addControl}} for details. For raster
data (Raster*/stars) a logical indicating whether to add image query.}

\item{query.type}{for raster methods only. Whether to show raster value query
on \code{'mousemove'} or \code{'click'}. Ignored if \code{label = FALSE}.}

\item{query.digits}{for raster methods only. The amount of digits to be shown
by raster value query. Ignored if \code{label = FALSE}.}

\item{query.position}{for raster methods only. The position of the raster
value query info box. See \code{position} argument of \code{\link{addLegend}}
for possible values. Ignored if \code{label = FALSE}.}

\item{query.prefix}{for raster methods only. a character string to be shown
as prefix for the layerId. Ignored if \code{label = FALSE}.}

\item{viewer.suppress}{deprecated.
Use \code{mapviewOptions(viewer.suppress = TRUE/FALSE)} instead.}

\item{hide}{if TRUE the layer will be hidden (i.e. unchecked) in the rendered map.}

\item{...}{additional arguments passed on to respective functions.
See \code{\link{addRasterImage}}, \code{\link{addCircles}},
\code{\link{addPolygons}}, \code{\link{addPolylines}} for details.
Furthermore, you can pass hidden arguments to some methods. See Details for
a list of supported hidden arguments.}

\item{band}{for stars layers, the band number to be plotted.}

\item{pane}{name of the map pane in which to render features. See
\code{\link{addMapPane}} for details. Currently only supported for vector layers.
  Ignored if \code{canvas = TRUE}. The default \code{"auto"} will create different panes
  for points, lines and polygons such that points overlay lines overlay polygons.
  Set to \code{NULL} to get default leaflet behaviour where allfeatures
  are rendered in the same pane and layer order is determined automatically/sequentially.}

\item{canvas}{whether to use canvas rendering rather than svg. May help
performance with larger data. See \url{https://leafletjs.com/index.html#canvas}
for more information. Only applicable for vector data. The default setting will
decide automatically, based on feature complexity.}

\item{zcol}{attribute name(s) or column number(s) in attribute table
of the column(s) to be rendered. See also Details.}

\item{burst}{whether to show all (TRUE) or only one (FALSE) layer(s).
See also Details.}

\item{color}{color (palette) for points/polygons/lines}

\item{cex}{attribute name(s) or column number(s) in attribute table
of the column(s) to be used for defining the size of circles}

\item{lwd}{line width}

\item{alpha}{opacity of lines}

\item{na.alpha}{opacity of missing values}

\item{popup}{either \code{logical}, \code{character vector} or a \code{list}
of HTML strings with the popup contents, usually created from
\code{\link[leafpop]{popupTable}}. See \code{\link{addControl}} for details.
If \code{FALSE} or \code{NULL} no popups will be created, if \code{TRUE}
a table with all feature attributes/columns will be created.
If a \code{character vector} of column names, the table will only show the
respective column entries.}

\item{highlight}{either \code{FALSE}, \code{NULL} or a list of styling
options for feature highlighting on mouse hover.
See \code{\link{highlightOptions}} for details.}

\item{maxpoints}{the maximum number of points making up the geometry.
In case of lines and polygons this refers to the number of vertices. See
Details for more information.}

\item{tms}{whether the tiles are served as TMS tiles.}

\item{y}{numeric vector.}

\item{type}{whether to render the numeric vector \code{x} as a
point \code{"p"} or line \code{"l"} plot.}

\item{grid}{whether to plot a (scatter plot) xy-grid to aid interpretation
of the visualisation. Only relevant for the data.frame method.}

\item{xcol}{the column to be mapped to the x-axis. Only relevant for the
data.frame method.}

\item{ycol}{the column to be mapped to the y-axis. Only relevant for the
data.frame method.}

\item{aspect}{the ratio of x/y axis corrdinates to adjust the plotting
space to fit the screen. Only relevant for the data.frame method.}

\item{crs}{an optional crs specification for the provided data to enable
rendering on a basemap. See argument description in \code{\link{st_sf}}
for details.}
}
\description{
this function produces an interactive view of the specified
spatial object(s) on top of the specified base maps.
}
\details{
If \code{zcol} is not \code{NULL} but a length one character vector
(referring to a column name of the attribute table)
and \code{burst} is \code{TRUE}, one layer for each unique value
of \code{zcol} will be drawn. The same will happen if \code{burst} is
a length one character vector (again referring to a column of
the attribute table). \cr
\cr
NOTE: if XYZ or XYM or XYZM data from package sf is passed to mapview,
dimensions Z and M will be stripped to ensure smooth rendering even though
the popup will potentially still say something like "POLYGON Z".

\code{maxpoints} is taken to determine when to switch rendering from svg
  to canvas overlay for perfomance. The threshold calculation is done as follows: \cr
  if the number of points (in case of point data) or vertices (in case of
  polygon or line data) > \code{maxpoints} then render using special render
  function. Within this render function we approximate the complexity of
  features by \cr
\cr
\code{maxFeatures <- maxfeatures / (npts(data) / length(data))} \cr
\cr
  where \code{npts} determines the number of points/vertices and \code{length}
  the number of features (points, lines or polygons). When the number of
  features in the current view window is larger than \code{maxFeatures} then
  features are rendered on the canvas, otherwise they are rendered as svg objects
  and fully queriable.\cr
  \cr
  Hidden arguments that can be set via \code{...}:\cr
  \cr
  * \code{hide}: hide all but the first layer when rendering a RasterStackBrick.
}
\section{Methods (by class)}{
\itemize{
\item \code{mapView(stars)}: \code{stars}

\item \code{mapView(stars_proxy)}: \code{stars_proxy}

\item \code{mapView(SpatRaster)}: \code{SpatRaster}

\item \code{mapView(RasterStackBrick)}: \code{\link{stack}} / \code{\link{brick}}

\item \code{mapView(Satellite)}: \code{\link{satellite}}

\item \code{mapView(sf)}: \code{sf}

\item \code{mapView(SpatVector)}: \code{SpatVector}

\item \code{mapView(sfc)}: \code{\link{st_sfc}}

\item \code{mapView(character)}: \code{\link{character}}

\item \code{mapView(numeric)}: \code{\link{numeric}}

\item \code{mapView(data.frame)}: \code{\link{data.frame}}

\item \code{mapView(XY)}: \code{\link{st_sfc}}

\item \code{mapView(XYZ)}: \code{\link{st_sfc}}

\item \code{mapView(XYM)}: \code{\link{st_sfc}}

\item \code{mapView(XYZM)}: \code{\link{st_sfc}}

\item \code{mapView(bbox)}: \code{\link{st_bbox}}

\item \code{mapView(missing)}: initiate a map without an object

\item \code{mapView(`NULL`)}: initiate a map without an object

\item \code{mapView(list)}: \code{\link{list}}

\item \code{mapview(ANY)}: alias for ease of typing

\item \code{mapView(SpatialPixelsDataFrame)}: \code{\link{SpatialPixelsDataFrame}}

\item \code{mapView(SpatialGridDataFrame)}: \code{\link{SpatialGridDataFrame}}

\item \code{mapView(SpatialPointsDataFrame)}: \code{\link{SpatialPointsDataFrame}}

\item \code{mapView(SpatialPoints)}: \code{\link{SpatialPoints}}

\item \code{mapView(SpatialPolygonsDataFrame)}: \code{\link{SpatialPolygonsDataFrame}}

\item \code{mapView(SpatialPolygons)}: \code{\link{SpatialPolygons}}

\item \code{mapView(SpatialLinesDataFrame)}: \code{\link{SpatialLinesDataFrame}}

\item \code{mapView(SpatialLines)}: \code{\link{SpatialLines}}

}}
\examples{
\dontrun{
  mapview()

  ## simple features ====================================================
  library(sf)

  # sf
  mapview(breweries)
  mapview(franconia)

  # sfc
  mapview(st_geometry(breweries)) # no popup

  # sfg / XY - taken from ?sf::st_point
  outer = matrix(c(0,0,10,0,10,10,0,10,0,0),ncol=2, byrow=TRUE)
  hole1 = matrix(c(1,1,1,2,2,2,2,1,1,1),ncol=2, byrow=TRUE)
  hole2 = matrix(c(5,5,5,6,6,6,6,5,5,5),ncol=2, byrow=TRUE)
  pts = list(outer, hole1, hole2)
  (pl1 = st_polygon(pts))
  mapview(pl1)

  ## raster ==============================================================
  if (interactive()) {
    library(plainview)

    mapview(plainview::poppendorf[[5]])
  }

  ## spatial objects =====================================================
  mapview(leaflet::gadmCHE)
  mapview(leaflet::atlStorms2005)


  ## styling options & legends ===========================================
  mapview(franconia, color = "white", col.regions = "red")
  mapview(franconia, color = "magenta", col.regions = "white")

  mapview(breweries, zcol = "founded")
  mapview(breweries, zcol = "founded", at = seq(1400, 2200, 200), legend = TRUE)
  mapview(franconia, zcol = "district", legend = TRUE)

  clrs <- sf.colors
  mapview(franconia, zcol = "district", col.regions = clrs, legend = TRUE)

  ### multiple layers ====================================================
  mapview(franconia) + breweries
  mapview(list(breweries, franconia))
  mapview(franconia) + mapview(breweries) + trails

  mapview(franconia, zcol = "district") + mapview(breweries, zcol = "village")
  mapview(list(franconia, breweries),
          zcol = list("district", NULL),
          legend = list(TRUE, FALSE))


  ### burst ==============================================================
  mapview(franconia, burst = TRUE)
  mapview(franconia, burst = TRUE, hide = TRUE)
  mapview(franconia, zcol = "district", burst = TRUE)


  ### ceci constitue la fin du pipe ======================================
  library(poorman)
  library(sf)

  franconia \%>\%
    sf::st_union() \%>\%
    mapview()

  franconia \%>\%
    group_by(district) \%>\%
    summarize() \%>\%
    mapview(zcol = "district")

  franconia \%>\%
    group_by(district) \%>\%
    summarize() \%>\%
    mutate(area = st_area(.) / 1e6) \%>\%
    mapview(zcol = "area")

  franconia \%>\%
    mutate(area = sf::st_area(.)) \%>\%
    mapview(zcol = "area", legend = TRUE)

  breweries \%>\%
    st_intersection(franconia) \%>\%
    mapview(zcol = "district")

  franconia \%>\%
    mutate(count = lengths(st_contains(., breweries))) \%>\%
    mapview(zcol = "count")

  franconia \%>\%
    mutate(count = lengths(st_contains(., breweries)),
           density = count / st_area(.)) \%>\%
    mapview(zcol = "density")
}

}
\author{
Tim Appelhans
}
