## -----------------------------------------------------------------------------
## Saturation Water Vapor Pressure
## -----------------------------------------------------------------------------
vapor <- function (S = 35, t = 25) {
  if (any (S < 0))
    stop ("Salinity should be >= 0")
  K <- 273.15 + t
  exp(24.4543 - 67.4509 * (100/K) - 4.8489 * log(K/100) - 0.000544 * S)
}

vapor.hPa <- function (t = 25){    # in hPa
  a0           <-  6.107799961
  a1           <-  4.436518521e-1
  a2           <-  1.428945805e-2
  a3           <-  2.650648471e-4
  a4           <-  3.031240396e-6
  a5           <-  2.034080948e-8
  a6           <-  6.136820929e-11
  i0           <-  6.109177956
  i1           <-  5.034698970e-1
  i2           <-  1.886013408e-2
  i3           <-  4.176223716e-4
  i4           <-  5.824720280e-6
  i5           <-  4.838803174e-8
  i6           <-  1.838826904e-10
  eTa           <-  a0 + t*(a1+t*(a2+t*(a3+t*(a4+t*(a5+t*a6)))))
  return(eTa)
}

