% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferences.R
\name{inferences}
\alias{inferences}
\title{(EXPERIMENTAL) Bootstrap, Conformal, and Simulation-Based Inference}
\usage{
inferences(
  x,
  method,
  R = 1000,
  conf_type = "perc",
  conformal_test = NULL,
  conformal_calibration = NULL,
  conformal_score = "residual_abs",
  estimator = NULL,
  ...
)
}
\arguments{
\item{x}{Object produced by one of the core \code{marginaleffects} functions, or a data frame suitable for the function supplied to the \code{estimator} argument.}

\item{method}{String
\itemize{
\item "delta": delta method standard errors
\item "boot" package
\item "fwb": fractional weighted bootstrap
\item "rsample" package
\item "simulation" from a multivariate normal distribution (Krinsky & Robb, 1986)
\item "mi" multiple imputation for missing data
\item "conformal_split": prediction intervals using split conformal prediction (see Angelopoulos & Bates, 2022)
\item "conformal_cv+": prediction intervals using cross-validation+ conformal prediction (see Barber et al., 2020)
}}

\item{R}{Number of resamples, simulations, or cross-validation folds.}

\item{conf_type}{String: type of bootstrap interval to construct.
\itemize{
\item \code{boot}: "perc", "norm", "basic", or "bca"
\item \code{fwb}: "perc", "norm", "basic", "bc", or "bca"
\item \code{rsample}: "perc" or "bca"
\item \code{simulation}: argument ignored.
}}

\item{conformal_test}{Data frame of test data for conformal prediction.}

\item{conformal_calibration}{Data frame of calibration data for split conformal prediction (\verb{method="conformal_split}).}

\item{conformal_score}{String. Warning: The \code{type} argument in \code{predictions()} must generate predictions which are on the same scale as the outcome variable. Typically, this means that \code{type} must be "response" or "probs".
\itemize{
\item "residual_abs" or "residual_sq" for regression tasks (numeric outcome)
\item "softmax" for classification tasks (when \code{predictions()} returns a \code{group} columns, such as multinomial or ordinal logit models.
}}

\item{estimator}{Function that accepts a data frame, fits a model, applies a marginaleffects function, and returns the object. Only supported with method="rsample" or method="boot". When method="rsample", the output must include a "term" column. This is not always the case for predictions(), in which case users may have to create the column manually.}

\item{...}{\itemize{
\item If \code{method="boot"}, additional arguments are passed to \code{boot::boot()}.
\item If \code{method="fwb"}, additional arguments are passed to \code{fwb::fwb()}.
\item If \code{method="rsample"}, additional arguments are passed to \code{rsample::bootstraps()}.
\item Additional arguments are ignored for all other methods.
}}
}
\value{
A \code{marginaleffects} object with simulation or bootstrap resamples and objects attached.
}
\description{
Warning: This function is experimental. It may be renamed, the user interface may change, or the functionality may migrate to arguments in other \code{marginaleffects} functions.

Apply this function to a \code{marginaleffects} object to change the inferential method used to compute uncertainty estimates.
}
\details{
When \code{method="simulation"}, we conduct simulation-based inference following the method discussed in Krinsky & Robb (1986):
\enumerate{
\item Draw \code{R} sets of simulated coefficients from a multivariate normal distribution with mean equal to the original model's estimated coefficients and variance equal to the model's variance-covariance matrix (classical, "HC3", or other).
\item Use the \code{R} sets of coefficients to compute \code{R} sets of estimands: predictions, comparisons, slopes, or hypotheses.
\item Take quantiles of the resulting distribution of estimands to obtain a confidence interval and the standard deviation of simulated estimates to estimate the standard error.
}

When \code{method="fwb"}, drawn weights are supplied to the model fitting function's \code{weights} argument; if the model doesn't accept non-integer weights, this method should not be used. If weights were included in the original model fit, they are extracted by \code{\link[=weights]{weights()}} and multiplied by the drawn weights. These weights are supplied to the \code{wts} argument of the estimation function (e.g., \code{comparisons()}).
}
\section{References}{


Krinsky, I., and A. L. Robb. 1986. "On Approximating the Statistical Properties of Elasticities." Review of Economics and Statistics 68 (4): 715–9.

King, Gary, Michael Tomz, and Jason Wittenberg. "Making the most of statistical analyses: Improving interpretation and presentation." American journal of political science (2000): 347-361

Dowd, Bryan E., William H. Greene, and Edward C. Norton. "Computation of standard errors." Health services research 49.2 (2014): 731-750.

Angelopoulos, Anastasios N., and Stephen Bates. 2022. "A Gentle Introduction to Conformal Prediction and Distribution-Free Uncertainty Quantification." arXiv. https://doi.org/10.48550/arXiv.2107.07511.

Barber, Rina Foygel, Emmanuel J. Candes, Aaditya Ramdas, and Ryan J. Tibshirani. 2020. "Predictive Inference with the Jackknife+." arXiv. http://arxiv.org/abs/1905.02928.
}

\examples{
\dontrun{
library(marginaleffects)
library(magrittr)
set.seed(1024)
mod <- lm(Sepal.Length ~ Sepal.Width * Species, data = iris)

# bootstrap
avg_predictions(mod, by = "Species") \%>\%
    inferences(method = "boot")

avg_predictions(mod, by = "Species") \%>\%
    inferences(method = "rsample")

# Fractional (bayesian) bootstrap
avg_slopes(mod, by = "Species") \%>\%
    inferences(method = "fwb") \%>\%
    get_draws("rvar") \%>\%
    data.frame()

# Simulation-based inference
slopes(mod) \%>\%
    inferences(method = "simulation") \%>\%
    head()

# Two-step estimation procedure: Propensity score + G-Computation
lalonde <- get_dataset("lalonde")
estimator <- function(data) {
    # Step 1: Estimate propensity scores
    fit1 <- glm(treat ~ age + educ + race, family = binomial, data = data)
    ps <- predict(fit1, type = "response")
    # Step 2: Fit weighted outcome model
    m <- lm(re78 ~ treat * (re75 + age + educ + race),
        data = data, weight = ps
    )
    # Step 3: Compute average treatment effect by G-computation
    avg_comparisons(m, variables = "treat", wts = ps, vcov = FALSE)
}
inferences(lalonde, method = "rsample", estimator = estimator)

}
}
