% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillN2.R
\name{hillN2}
\alias{hillN2}
\title{Calculates Hill's Species Dominance (N2)}
\usage{
hillN2(X, groups, species.table = NULL, metric = "ABUNDANCE", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{ABUNDANCE}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{ABUNDANCE} is the corresponding abundance
(stratified and corrected for catchability as required).}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicator. Default is \code{metric = "ABUNDANCE"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
 column \code{HillDominance_group} for each entry in \code{groups}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 values is assigned NA.
}
\description{
This function calculates Hill's Species Dominance (N2) for
 \eqn{j} areas and \eqn{i} years.
}
\details{
Hill's Species Dominance (HillN2): \deqn{HillN2 = 1/\Sigma p_i^2}
 \eqn{p_i} is the proportion of the total sample contributed by the i(th)
 species. HillN2 is the inverse of the Simpson's index. This index is
 sensitive to the evenness of the distribution of individuals between species
 (Hill, 1973).
}
\examples{
data(X)
hillN2(X, groups = "ALL", metric = "ABUNDANCE", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Greenstreet SP, Rogers SI. 2006. Indicators of the health of the North Sea
 fish community: identifying reference levels for an ecosystem approach to
 management. ICES J Mar Sci J du Cons 63:573-593

 Hill MO. 1973. Diversity and evenness: a unifying notation and its
 consequences. Ecology 54: 427-431.
}
\seealso{
Other biodiversity indicators: \code{\link{allBiodiversity}},
  \code{\link{heips}}, \code{\link{hillN1}},
  \code{\link{kemptonQ}}, \code{\link{margalef}},
  \code{\link{pielouEvenness}}, \code{\link{shannon}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
