% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcing.R
\name{eval_named_chunk}
\alias{eval_named_chunk}
\title{Evaluate a  Named Chunk}
\usage{
eval_named_chunk(rmd_file, label_name)
}
\arguments{
\item{rmd_file}{Absolute path to rmd file}

\item{label_name}{Name of label}
}
\value{
The value from the evaluated code chunk
}
\description{
Evaluate a named chunk from an Rmd file.
}
\examples{
temp_rmd <- tempfile(fileext = ".rmd")

text <- '
```{r not this label}
print("that is wrong")
```

```{r hello label}
text <- "hello, world"
print(text)
print(TRUE)
```

```{r another label}
warning("wrong label")
```
'

writeLines(text, con = temp_rmd)

eval_named_chunk(temp_rmd, "hello label")
# [1] "hello, world"
# [1] TRUE

file.remove(temp_rmd)
}
