% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff-time.R
\name{diff_time}
\alias{diff_time}
\alias{diff_time_days}
\alias{diff_time_weeks}
\alias{diff_time_hours}
\alias{diff_time_mins}
\alias{diff_time_secs}
\alias{diff_time_months}
\alias{diff_time_years}
\alias{diff_time_dyears}
\alias{diff_time_wyears}
\alias{diff_time_myears}
\title{Diff time wrappers}
\usage{
diff_time(
  x,
  y,
  method = c("secs", "mins", "hours", "days", "weeks", "months", "years", "dyears",
    "wyears", "myears"),
  tzx = NULL,
  tzy = tzx
)

diff_time_days(x, y, ...)

diff_time_weeks(x, y, ...)

diff_time_hours(x, y, ...)

diff_time_mins(x, y, ...)

diff_time_secs(x, y, ...)

diff_time_months(x, y, ...)

diff_time_years(x, y, ...)

diff_time_dyears(x, y, ...)

diff_time_wyears(x, y, ...)

diff_time_myears(x, y, ...)
}
\arguments{
\item{x, y}{Vectors of times}

\item{method}{A method to report the difference in units of time (see
\strong{Units} section)}

\item{tzx, tzy}{time zones (see \strong{Time zones} section)}

\item{...}{Additional arguments passed to \code{diff_time()}}
}
\value{
A \code{diff_time} vector, object
}
\description{
Wrappers for computing diff times
}
\details{
A few significant differences exist with these functions * The class
of the object returned is no longer \code{difftime} (but does print) with the
\code{difftime} method.  This makes the exporting process easier as the data
will not have to be converted back to \code{numeric} * \code{difftime()} computes the
difference of \code{time1} - \code{time2}, but the inverse feels a bit more nature:
time difference from \code{x} to \code{y} * Additional units can be used (detailed
below) * Differences can be sensitive to time zones if time zones are
passed to the \code{tz} parameter as a character vector
}
\section{Units}{
 Units can be used beyond those available in
\code{base::difftime()}.  Some of these use assumptions in how units of time
should be standardized and can be changed in the corresponding options. Any
of these can be calculated with \code{base::difftime()} through using \code{units = "days"} but the \code{dtime} class will print out with these specifications into
the console for less potential confusion.

\describe{
\item{months}{Months by number of days \code{mark.days_in_month} (defaults: \code{30})}
\item{years}{Years by number of days \code{mark.days_in_year} (defaults: \code{365})}
\item{dyears}{Years by number of days \code{mark.days_in_year} (defaults: \code{365}) (same as \code{years})}
\item{myears}{Years by number of days in a month \code{mark.days_in_month} (defaults: \code{30})}
\item{wyears}{Years by number of weeks in a year \code{mark.weeks_in_year} (defaults: \code{52})}
}
}

\section{Time zones}{
 Time zones can be passed as either a numeric vector of
GMT/UTC offsets (the number of seconds from GMT) or as a character vector.
If the letter, these need to conform with values from \code{base::OlsonNames()}.

A default timezone can be set with \code{options(mark.default_tz = .)}.  The
value can either be a numeric
}

