% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{counts}
\alias{counts.data.frame}
\alias{props}
\alias{props.default}
\alias{props.data.frame}
\title{Count observations by unique values}
\usage{
counts(x, ...)

\method{counts}{data.frame}(x, cols, sort = FALSE, ..., .name = "freq")

props(x, ...)

\method{props}{default}(x, sort = FALSE, na.rm = FALSE, ...)

\method{props}{data.frame}(x, cols, sort = FALSE, na.rm = FALSE, ..., .name = "prop")
}
\arguments{
\item{x}{A vector or \code{data.frame}}

\item{...}{Arguments passed to other methods}

\item{cols}{A vector of column names or indexes}

\item{sort}{Logical, if \code{TRUE} will sort values (not counts) before
returning. For factors this will sort by factor levels.  This has no effect
for logical vectors, which already return in the order of \code{FALSE}, \code{TRUE},
\code{NA}.}

\item{.name}{The name of the new column}

\item{na.rm}{If \code{TRUE} will remove NA values from proportions}
}
\value{
A named vector of \code{integer}s or \code{double}s (for \code{counts}, and \code{props},
respectively) or \code{data.frame} with columns for each column chosen and the
\code{.name} chosen for the summary
}
\description{
Variables will be return by the order in which they appear.  Even factors are
shown by their order of appearance in the vector.

There are 2 methods for counting vectors.  The \code{default} method uses
\code{base::tabulate()} (the workhorse for \code{base::table()} with a call to
\code{pseudo_id()} to transform all inputs into integers.  The \code{logical} method
counts \code{TRUE}, \code{FALSE} and \code{NA} values, which is much quicker.
}
\details{
Get counts or proportions of unique observations in a vector or columns in a
\code{data.frame}
}
\examples{
x <- sample(1:5, 10, TRUE)
counts(x)
props(x)

x <- quick_df(list(
  a = c("a", "c", "a", "c", "d", "b"),
  b = c("a", "a", "a", "c", "c", "b"),
  c = c("a", "a", "a", "c", "b", "b")
))

counts(x, "a")
counts(x, c("a", "b", "c"))
props(x, 2)
props(x, 1:3)

props(c(1, 1, 3, NA, 4))
props(c(1, 1, 3, NA, 4), na.rm = TRUE)
}
