% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxi_trend.R
\name{cxi_trend}
\alias{cxi_trend}
\title{Tidy Calculation of Customer Experience Index trends by group}
\usage{
cxi_trend(
  survey_data,
  trend_var,
  ...,
  cx_high = 4,
  cx_low = 2,
  min_surveys = 1,
  avg_surveys = 0
)
}
\arguments{
\item{survey_data}{Raw survey data. Needs to be one row per survey with the three CXi question
responses having column names of needs, ease and emotion}

\item{trend_var}{Column that represents an element of time, eg week number, date, month & year}

\item{...}{optional columns by which to group the CXi calculation. There is no limit to
the number of grouping variables chosen. Too many will likely result in CXi calculations
that are too fragmented / based on very small survey counts.}

\item{cx_high}{Threshold in scale where response at or above is a "high"}

\item{cx_low}{Threshold in scale where response at or below is a "low"}

\item{min_surveys}{Minimum surveys found in every period for each group to be included}

\item{avg_surveys}{Average surveys found in every period for each group to be included}
}
\value{
Data frame with CXi and survey count for each combination of the grouping variables over
the time variable.
}
\description{
Simplifies the calculation of Customer Experience Index (CXi) trends over time from raw survey
data within the tidyverse framework.
}
\details{
Customer Experience Index is a metric created by Forrester to help companies systematically
measure customer experience in a way that their research has found is connected to
improving customer loyalty. More information can be found at https://go.forrester.com/analytics/cx-index/

The calculation across an entire sample of surveys is simple. A customer experience
manager may want to calculate CXi across many different dimensions and filtering
in different ways; the functions in this package utilize the tidy framework to streamline
calculating CXi along as many dimensions as desired.

The trend version of the function allows you to specify one column as a date over which to
trend the data. This allows quick filtering to eliminate groupings that fail to meet
user-specified thresholds for average or minimum survey counts per time period.

The resulting data set is set up for creating faceted line plots using ggplot2.
}
\examples{
needs <- sample(5, 100, replace = TRUE)
ease <- sample(5, 100, replace = TRUE)
emotion <- sample(5, 100, replace = TRUE)
cx_date <- rep(seq.Date(from = as.Date("2019-01-01"), to = as.Date("2019-01-10"), by = "day"), 10)
cx_group <- rep(c("a", "b", "c", "d"), 25)
df <- data.frame(needs, ease, emotion, cx_date, cx_group)
cxi_trend(df, cx_date, cx_group)
}
