% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equation_base.R, R/equation_basic.R,
%   R/equation_deterministic_adjustment.R, R/equation_directional.R,
%   R/equation_stochastic_adjustment.R
\docType{class}
\name{equation_classes}
\alias{equation_classes}
\alias{equation_base-class}
\alias{equation_basic-class}
\alias{equation_deterministic_adjustment-class}
\alias{equation_directional-class}
\alias{equation_stochastic_adjustment-class}
\title{Equation classes}
\description{
Equation classes
}
\details{
Classes with data and functionality describing equations of model systems.
}
\section{Functions}{
\itemize{
\item \code{equation_base-class}: Equation base class

\item \code{equation_basic-class}: Basic disequilibrium model equation class

\item \code{equation_deterministic_adjustment-class}: Deterministic adjustment disequilibrium model equation
class

\item \code{equation_directional-class}: Directional disequilibrium model equation class

\item \code{equation_stochastic_adjustment-class}: Stochastic adjustment disequilibrium model equation class
}}

\section{Slots}{

\describe{
\item{\code{formula}}{The equation formula using prefixed variables.}

\item{\code{name}}{The name of the equation.}

\item{\code{variable_prefix}}{A prefix string for the variables of the equation.}

\item{\code{dependent_vector}}{The vector of the response.}

\item{\code{independent_matrix}}{A model data matrix with columns corresponding to the set
of independent variables.}

\item{\code{price_vector}}{The vector of prices.}

\item{\code{control_matrix}}{A model data matrix with columns corresponding to the set
of independent variables without prices.}

\item{\code{alpha_beta}}{A vector of right hand side coefficients.}

\item{\code{alpha}}{The price coefficient.}

\item{\code{beta}}{A vector of right hand side coefficient without the price coefficient.}

\item{\code{var}}{The variance of the equation's shock.}

\item{\code{sigma}}{The standard deviation of the equation's shock.}

\item{\code{h}}{\deqn{h_{x} = \frac{x - \mathrm{E} x}{\sqrt{\mathrm{Var} x}}}}

\item{\code{z}}{\deqn{z_{xy} = \frac{h_{x} - \rho_{xy}h_{y}}{\sqrt{1 - \rho_{xy}^2}}}}

\item{\code{psi}}{\deqn{\psi_{x} = \phi(h_{x})}}

\item{\code{Psi}}{\deqn{\Psi_{x} = 1 - \Phi(z_{xy})}}

\item{\code{mu_Q}}{\deqn{\mu_{Q} = \mathrm{E}Q}}

\item{\code{var_Q}}{\deqn{V_{Q} = \mathrm{Var}Q}}

\item{\code{sigma_Q}}{\deqn{\sigma_{Q} = \sqrt{\mathrm{Var}Q}}}

\item{\code{rho_QP}}{\deqn{\rho_{Q} =
\frac{\mathrm{Cov}(Q,P)}{\sqrt{\mathrm{Var}Q\mathrm{Var}P}}}}

\item{\code{rho_1QP}}{\deqn{\rho_{1,QP} = \frac{1}{\sqrt{1 - \rho_{QP}}}}}

\item{\code{rho_2QP}}{\deqn{\rho_{2,QP} = \rho_{QP}\rho_{1,QP}}}

\item{\code{sigma_QP}}{\deqn{\sigma_{QP} = \mathrm{Cov}(Q,P)}}

\item{\code{h_Q}}{As in slot \code{h}}

\item{\code{z_PQ}}{As in slot \code{z}}

\item{\code{z_QP}}{As in slot \code{z}}

\item{\code{separation_subset}}{A vector of indicators specifying the observations of the
sample described by this equation according to the separation rule of the model.}
}}

\keyword{internal}
