% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{marginal_effects}
\alias{marginal_effects}
\alias{shortage_marginal}
\alias{shortage_probability_marginal}
\alias{shortage_marginal,missing,ANY,market_model,ANY-method}
\alias{shortage_probability_marginal,missing,ANY,ANY,market_model,ANY-method}
\alias{shortage_marginal,market_fit,ANY,missing,missing-method}
\alias{shortage_probability_marginal,market_fit,ANY,ANY,missing,missing-method}
\title{Marginal effects}
\usage{
shortage_marginal(fit, variable, model, parameters)

shortage_probability_marginal(
  fit,
  variable,
  aggregate = "mean",
  model,
  parameters
)

\S4method{shortage_marginal}{missing,ANY,market_model,ANY}(variable, model, parameters)

\S4method{shortage_probability_marginal}{missing,ANY,ANY,market_model,ANY}(variable, aggregate, model, parameters)

\S4method{shortage_marginal}{missing,ANY,market_model,ANY}(variable, model, parameters)

\S4method{shortage_marginal}{market_fit,ANY,missing,missing}(fit, variable)

\S4method{shortage_probability_marginal}{market_fit,ANY,ANY,missing,missing}(fit, variable, aggregate)
}
\arguments{
\item{fit}{A fitted market model.}

\item{variable}{Variable name for which the effect is calculated.}

\item{model}{A market model object.}

\item{parameters}{A vector of parameters.}

\item{aggregate}{Mode of aggregation. Valid options are "mean" (the
default) and "at_the_mean".}
}
\value{
The estimated effect of the passed variable.
}
\description{
Returns the estimated effect of a variable.
}
\section{Functions}{
\itemize{
\item \code{shortage_marginal}: Marginal effect on market system

Returns the estimated marginal effect of a variable on the market system. For a
system variable \eqn{x} with demand coefficient \eqn{\beta_{d, x}} and supply
coefficient \eqn{\beta_{s, x}}, the marginal effect on the market system  is
given by
\deqn{M_{x} = \frac{\beta_{d, x} - \beta_{s, x}}{\sqrt{\sigma_{d}^{2} +
\sigma_{s}^{2} - 2 \rho_{ds} \sigma_{d} \sigma_{s}}}.}

\item \code{shortage_probability_marginal}: Marginal effect on shortage probabilities

Returns the estimated marginal effect of a variable on the probability of
observing a shortage state. The mean marginal effect on the shortage probability
is given by
\deqn{M_{x} \mathrm{E} \phi\left(\frac{D - S}{\sqrt{\sigma_{d}^2 + \sigma_{s}^2 - 2 rho \sigma_{d} \sigma_{s}}}\right)}
and the marginal effect at the mean by
\deqn{M_{x} \phi\left(\mathrm{E}\frac{D - S}{\sqrt{\sigma_{d}^2 + \sigma_{s}^2 - 2 rho \sigma_{d} \sigma_{s}}}\right)}
where \eqn{M_{x}} is the marginal effect on the system, \eqn{D} is the demanded
quantity, \eqn{S} the supplied quantity, and \eqn{\phi} is the standard normal
density.
}}

\examples{
\donttest{
# estimate a model using the houses dataset
fit <- diseq_deterministic_adjustment(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  correlated_shocks = FALSE,
  estimation_options = list(control = list(maxit = 1e+5))
)

# mean marginal effect of variable "RM" on the shortage probabilities
#' shortage_probability_marginal(fit, "RM")

# marginal effect at the mean of variable "RM" on the shortage probabilities
shortage_probability_marginal(fit, "CSHS", aggregate = "at_the_mean")

# marginal effect of variable "RM" on the system
shortage_marginal(fit, "RM")
}
}
