% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC.test.R
\name{AUC.test}
\alias{AUC.test}
\title{Global test and local test for checking the Markov condition on Multi-state 
Models based on the Area Under the two curves (AUC) given by the non-Markov
estimators of the transition probabilities to the Markov Aalen-Johansen 
estimators.}
\usage{
AUC.test(
  db_long,
  db_wide = NULL,
  from = 1,
  to = 3,
  type = "global",
  times = NULL,
  quantiles = c(0.05, 0.1, 0.2, 0.3, 0.4),
  tmat = NULL,
  replicas = 10,
  limit = 0.9,
  positions = list(c(2, 3), c(3), c()),
  namesStates = c("Alive", "Rec", "Death"),
  timesNames = c(NA, "time1", "Stime"),
  status = c(NA, "event1", "event")
)
}
\arguments{
\item{db_long}{A data frame in long format containing the subject \code{id};
\code{from} corresponding to the starting state;the receiving state, 
\code{to}; the transition number, \code{trans}; the starting time of the
transition given by \code{Tstart}; the stopping time of the transition, 
\code{Tstop}, and \code{status} for the  status variable, with 1 indicating
an event (transition), 0 a censoring.}

\item{db_wide}{Data frame in wide format in which to interpret time, status,
id or keep, if appropriate.}

\item{from}{The starting state of the transition probabilities.}

\item{to}{The last receiving state considered for the estimation of the
transition probabilities. All  the probabilities among the first and the
last states are also computed.}

\item{type}{Type of test for checking the Markov condition: "local" or 
"global". By default type='global'.}

\item{times}{For the local test, times represents the starting times of the 
transition probabilities. In case of a global test, the argument is given by
times between the minimum time and the third quartile times used
in the formula of this test. Default to NULL.}

\item{quantiles}{Quantiles used in the formula of the Global test for the
AUC methods. By default takes the percentiles 0.05, 0.10, 0.20, 0.30, 0.40.}

\item{tmat}{The transition matrix for multi-state model.}

\item{replicas}{Number of replicas for the Monte Carlo simulation to
standardization of the T-statistic given by the difference of the areas of
AJ and LM transition probabilities estimates.}

\item{limit}{Percentile of the event time used as the upper bound for the
computation of the AUC-based test.}

\item{positions}{List of possible transitions; x[[i]] consists of a vector of
state numbers reachable from state i.}

\item{namesStates}{A character vector containing the names of either the
competing risks or the states in the multi-state model specified by the
competing risks or illness-death model. names should have the same length as
the list x (for transMat), or either K or K+1 (for trans.comprisk), or 3
(for trans.illdeath).}

\item{timesNames}{Either 1) a matrix or data frame of dimension n x S
(n being the number of individuals  and S the number of states in the
multi-state model), containing the times at which the states are visited or
last follow-up time, or 2) a character vector of length S containing the
column names  indicating these times. In the latter cases, some elements of
time may be NA, see Details}

\item{status}{Either 1) a matrix or data frame of dimension n x S,
containing, for each of the states, event indicators taking the value 1 if
the state is visited or 0 if it is not (censored), or 2) a character
vector of length S containing the column names indicating these status
variables. In the latter cases, some elements of status may be NA, 
see Details.}
}
\value{
In case of the AUC global test, an object with a list with the 
following outcomes:
\item{globalTest}{p-value of AUC global tests for each transition. These
values are obtained through the minimum of the means of each two contiguous
quantiles times of the AUC global tests.} 
\item{localTest}{AUC local tests of the transition probability for each times
and transitions.}
\item{quantiles}{Quantiles times used for the AUC global tests.}
\item{times}{Times used for the AUC global tests.}
\item{DIF}{Differences between the AJ and the LMAJ estimates for each
transition probabilites from the starting state until the receiving state
given by only one replica where 's' represent each of the quantile times.}  
\item{from}{The starting state considered for the AUC global tests.}
\item{to}{The last receiving state considered for the the AUC Local tests.}
\item{ET.qiAll}{The lower limit of the diferences between the AJ and the LMAJ
estimates given by the Monte Carlo simulation in each transition for each "s"
quantile times. \code{ET.qi2All} means the same but missing values were
replaced by the previous diferences of estimators.} 
\item{ET.qsAll}{The upper limit of the diferences between the AJ and the LMAJ
estimates given by the Monte Carlo simulation in each transition for each "s"
quantile times. \code{ET.qs2All} means the same but missing values were
replaced by the previous diferences of estimators.} 
\item{replicas}{Number of replicas for the Monte Carlo simulation.}
\item{limit}{Percentil of the times used in the AUC global tests.}

In case of the AUC local test, an object with a list with the following 
outcomes:
\item{localTest}{p-value of AUC local tests for each times and transitions.}
\item{trans}{The transition matrix describing the states and transitions of
the multi-state model.}
\item{times}{Times selected for the AUC Local tests.}
\item{DIF}{Differences between the AJ and the LMAJ estimates for each
transition probabilites from the starting state until the receiving state
given by only one replica where 's' represent each of the  quantile times.}  
\item{from}{The starting state considered for the AUC Local tests.}
\item{to}{The last receiving state considered for the the AUC Local tests.}
\item{ET.qiAll}{The lower limit of the diferences between the AJ and the LMAJ
estimates given by the Monte Carlo simulation in each transition for each "s"
quantile times. \code{ET.qi2All} means the same but missing values were 
replaced by the previous diferences of estimators.} 
\item{ET.qsAll}{The upper limit of the diferences between the AJ and the LMAJ
estimates given by the Monte Carlo simulation in each transition for each "s"
quantile times. \code{ET.qs2All} means the same but missing values were
replaced by the previous diferences of estimators.} 
\item{replicas}{Number of replicas for the Monte Carlo simulation.}
\item{limit}{Percentil of the times used in the AUC local tests.}
}
\description{
This function is used to obtain the local and global tests for 
checking the Markov condition.
}
\examples{
set.seed(1234)
library(markovMSM)
data("colonMSM")
db_wide<-colonMSM
positions<-list(c(2, 3), c(3), c())
namesStates =  c("Alive", "Rec",  "Death")
tmat <-transMatMSM(positions, namesStates)
timesNames = c(NA, "time1","Stime")
status=c(NA, "event1","event")
trans = tmat
\donttest{
db_long<- prepMSM(data=db_wide, trans, timesNames, status)
res<-AUC.test(db_long, db_wide, times=180, from=1, to=3, type='local',
               replicas=100, tmat = tmat)

res$localTest
res2<-AUC.test(db_long, db_wide, times=180, from=2, to=3, type='local',
               replicas=100, tmat = tmat)
res2$localTest

res3<-AUC.test(db_long, db_wide, from=1, to=3, replicas = 100, tmat=tmat)
round(res3$globalTest,3)

res4<-AUC.test(db_long, db_wide, from=2, to=3, type='global', replicas = 100,
             tmat=tmat)
round(res4$globalTest,3)

round(res4$localTest,3)
round(res4$localTest,3)

data("ebmt4")
db_wide <- ebmt4
positions <- list(c(2, 3, 5, 6), c(4, 5, 6), c(4, 5, 6),
                 c(5, 6), c(), c())
state.names <- c("Tx", "Rec", "AE", "Rec+AE", "Rel", "Death")
tmat <-transMatMSM(positions, state.names)
timesNames <- c(NA, "rec", "ae","recae", "rel", "srv")
status <- c(NA, "rec.s", "ae.s", "recae.s","rel.s", "srv.s")
trans <- tmat

db_long <- prepMSM(data=db_wide, trans, timesNames, status)
db_long[1:10,]

res5<-AUC.test(db_long, db_wide, from=1, to=5, type='global',
               quantiles=c(.05, .10, .20, .30, 0.40),
               tmat = tmat, replicas = 100,
               positions=positions, namesStates=state.names,
               timesNames=timesNames, status=status)
               
round(res5$globalTest, 4)
round(res5$localTests,4)

res6<-AUC.test(db_long = prothr, db_wide = NULL, from=2, to=3,
               type='global', replicas=100, limit=0.90,
               quantiles=c(.05, .10, .20, .30, 0.40))
round(res6$globalTest,4)

round(res6$localTests,4)
}
}
\references{
Soutinho G, Meira-Machado L (2021). Methods for checking the 
Markov condition in multi-state survival data. \emph{Computational Statistics}.
de Una-alvarez J, Meira-Machado L (2015). Nonparametric estimation of 
transition probabilities in the non-Markov illness-death model: A comparative
study. \emph{Biometrics}, 71(2), 364-375.
Putter H, Spitoni C (2018). Non-parametric estimation of transition 
probabilities in non-Markov multi-state models: The landmark Aalen-Johansen 
estimator. \emph{Statistical Methods in Medical Research}, 27, 2081-2092.
Meira-Machado L, Sestelo M (2019). Estimation in the progressive illness-death
model: A nonexhaustive review. \emph{Biometrical Journal}, 61(2), 245-263.
}
\author{
Gustavo Soutinho and Luis Meira-Machado.
}
