% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_ctmcProbabilisticSAI.R
\name{impreciseProbabilityatT}
\alias{impreciseProbabilityatT}
\title{Calculating full conditional probability using lower rate transition matrix}
\usage{
impreciseProbabilityatT(C,i,t,s,error,useRCpp)
}
\arguments{
\item{C}{a ictmc class object}

\item{i}{initial state at time t}

\item{t}{initial time t. Default value = 0}

\item{s}{final time}

\item{error}{error rate. Default value = 0.001}

\item{useRCpp}{logical whether to use RCpp implementation; by default TRUE}
}
\description{
This function calculates full conditional probability at given 
time s using lower rate transition matrix
}
\examples{
states <- c("n","y")
Q <- matrix(c(-1,1,1,-1),nrow = 2,byrow = TRUE,dimnames = list(states,states))
range <- matrix(c(1/52,3/52,1/2,2),nrow = 2,byrow = 2)
name <- "testictmc"
ictmc <- new("ictmc",states = states,Q = Q,range = range,name = name)
impreciseProbabilityatT(ictmc,2,0,1,10^-3,TRUE)

}
\references{
Imprecise Continuous-Time Markov Chains, Thomas Krak et al., 2016
}
\author{
Vandit Jain
}
