% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_common_cov.R
\name{compute_posterior_matrices_common_cov_R}
\alias{compute_posterior_matrices_common_cov_R}
\title{Compute posterior matrices (when error covariance V_j is
  equal for all observations j)}
\usage{
compute_posterior_matrices_common_cov_R(
  data,
  A,
  Ulist,
  posterior_weights,
  output_posterior_cov = FALSE,
  posterior_samples = 0,
  seed = 123
)
}
\arguments{
\item{data}{a mash data object, eg as created by
\code{mash_set_data} or \code{mash_set_data_contrast}}

\item{A}{the linear transformation matrix, Q x R matrix. This is
used to compute the posterior for Ab.}

\item{Ulist}{a list of P covariance matrices for each mixture component}

\item{posterior_weights}{the JxP posterior probabilities of each
mixture component in Ulist for the data}

\item{output_posterior_cov}{whether or not to output posterior
covariance matrices for all effects}

\item{posterior_samples}{the number of samples to be drawn from the
posterior distribution of each effect.}

\item{seed}{a random number seed to use when sampling from the
posteriors. It is used when \code{posterior_samples > 0}.}
}
\value{
PosteriorMean JxQ matrix of posterior means

PosteriorSD JxQ matrix of posterior (marginal) standard deviations

NegativeProb JxQ matrix of posterior (marginal) probability
  of being negative

ZeroProb JxQ matrix of posterior (marginal) probability of
  being zero

lfsr JxQ matrix of local false sign rates

PosteriorCov QxQxJ array of posterior covariance matrices,
  if the \code{output_posterior_cov = TRUE}

PosteriorSamples JxQxM array of samples, if the
  \code{posterior_samples = M > 0}
}
\description{
This is an internal (non-exported) function. This help
  page provides additional documentation mainly intended for
  developers and expert users.
}
\details{
The computations are performed without allocating an
  excessive amount of memory.
}
\keyword{internal}
