% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{compute_posterior_matrices}
\alias{compute_posterior_matrices}
\title{Compute posterior matrices.}
\usage{
compute_posterior_matrices(
  data,
  Ulist,
  posterior_weights,
  algorithm.version = c("Rcpp", "R"),
  A = NULL,
  output_posterior_cov = FALSE,
  mc.cores = 1,
  posterior_samples = 0,
  seed = 123
)
}
\arguments{
\item{data}{A \code{mash} data object; e.g., created by
\code{\link{mash_set_data}} or \code{\link{mash_set_data_contrast}}.}

\item{Ulist}{List containing the prior covariance matrices.}

\item{posterior_weights}{Vector containing the posterior
probability of each mixture component in Ulist for the data.}

\item{algorithm.version}{Indicates whether to use R or Rcpp version.}

\item{A}{the linear transformation matrix, Q x R matrix. This is
used to compute the posterior for Ab.}

\item{output_posterior_cov}{whether or not to output posterior
covariance matrices for all effects.}

\item{mc.cores}{The argument supplied to
\code{openmp} specifying the number of cores
to use. Note that this is only has an effect for the Rcpp version.}

\item{posterior_samples}{the number of samples to be drawn from the
posterior distribution of each effect.}

\item{seed}{a random number seed to use when sampling from the
posteriors. It is used when \code{posterior_samples > 0}.}
}
\value{
The return value is a list containing the following
   components:

   \item{PosteriorMean}{J x Q matrix of posterior means.}

   \item{PosteriorSD}{J x Q matrix of posterior (marginal) standard
   deviations.}

   \item{NegativeProb}{J x Q matrix of posterior (marginal)
    probability of being negative.}

   \item{ZeroProb}{J x Q matrix of posterior (marginal) probability
    of being zero.}

   \item{lfsr}{J x Q matrix of local false sign rate estimates.}

   \item{lfdr}{J x Q matrix of local false discovery rate
     estimates.}

   \item{PosteriorCov}{Q x Q x J array of posterior covariance
     matrices, if the \code{output_posterior_cov = TRUE}.}

   \item{PosteriorSamples}{M x Q x J array of samples, if the
     \code{posterior_samples = M > 0}.}
}
\description{
Compute posterior matrices.
}
\keyword{internal}
