% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data2cov.R
\name{cov_flash}
\alias{cov_flash}
\title{Perform Empirical Bayes Matrix Factorization using flashr, and
  return a list of candidate covariance matrices}
\usage{
cov_flash(
  data,
  factors = c("default", "nonneg"),
  subset = NULL,
  remove_singleton = FALSE,
  tag = NULL,
  output_model = NULL,
  greedy_args = list(),
  backfit_args = list()
)
}
\arguments{
\item{data}{A \dQuote{mash} data object.}

\item{factors}{If \code{factors = "default"}, the factors and
loadings are both unconstrained. If \code{factors = "nonneg"}, the
factors are constrained to be non-negative, and the loadings are
unconstrained.}

\item{subset}{Data samples (rows) used to estimate the
covariances. Sset to \code{NULL} to use all the data.}

\item{remove_singleton}{If \code{remove_singleton = TRUE}, factors
corresponding to singleton matrices will be removed from the output.}

\item{tag}{How to name the covariance matrices.}

\item{output_model}{The fitted flash model will be saved to this file
(using \code{\link{saveRDS}}).}

\item{greedy_args}{List containing additional parameters passed to
\code{flashier::flash.add.greedy}.}

\item{backfit_args}{List containing additional parameters passed
to \code{flashier::flash.backfit}.}
}
\value{
A list of covariance matrices.
}
\description{
Perform Empirical Bayes Matrix Factorization using flashr, and
  return a list of candidate covariance matrices
}
\examples{
# See https://stephenslab.github.io/mashr/articles/flash_mash.html
# for an example

}
