% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_settings.R
\name{add_settings}
\alias{add_settings}
\alias{add_settings.gee_bp}
\alias{add_settings.cor_bp}
\alias{add_settings.glm_bp}
\alias{add_settings.pls_bp}
\alias{add_settings.t.test_bp}
\title{Add analysis settings to the blueprint}
\usage{
add_settings(data, ...)

\method{add_settings}{gee_bp}(
  data,
  cluster.id,
  family,
  corstr = c("independence", "exchangeable", "ar1"),
  conf.int = TRUE,
  conf.level = 0.95,
  ...
)

\method{add_settings}{cor_bp}(
  data,
  method = c("pearson", "kendall", "spearman"),
  use = c("complete.obs", "all.obs", "pairwise.complete.obs", "everything",
    "na.or.complete"),
  hclust.order = FALSE,
  ...
)

\method{add_settings}{glm_bp}(data, family, conf.int = TRUE, conf.level = 0.95, ...)

\method{add_settings}{pls_bp}(
  data,
  ncomp = NULL,
  scale = TRUE,
  validation = c("none", "CV", "LOO"),
  cv.data = TRUE,
  cv.seed = 1234,
  ...
)

\method{add_settings}{t.test_bp}(data, paired = FALSE, ...)
}
\arguments{
\item{data}{The blueprint data object.}

\item{...}{Additional args.}

\item{cluster.id}{Variable that represents the cluster for GEE.}

\item{family}{a description of the error distribution and link
    function to be used in the model.  For \code{glm} this can be a
    character string naming a family function, a family function or the
    result of a call to a family function.  For \code{glm.fit} only the
    third option is supported.  (See \code{\link[stats]{family}} for details of
    family functions.)}

\item{corstr}{The correlation structure. See \code{\link[geepack:geeglm]{geepack::geeglm()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{method}{the method to be used in fitting the model.  The default
    method \code{"glm.fit"} uses iteratively reweighted least squares
    (IWLS): the alternative \code{"model.frame"} returns the model frame
    and does no fitting.

    User-supplied fitting functions can be supplied either as a function
    or a character string naming a function, with a function which takes
    the same arguments as \code{glm.fit}.  If specified as a character
    string it is looked up from within the \pkg{stats} namespace.
  }

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{hclust.order}{Whether to order the correlation data based on the
\code{\link[stats:hclust]{stats::hclust()}} algorithm.}

\item{ncomp}{the number of components to include in the model (see below).}

\item{scale}{numeric vector, or logical.  If numeric vector, \eqn{X}
    is scaled by dividing each variable with the corresponding element
    of \code{scale}.  If \code{scale} is \code{TRUE}, \eqn{X} is scaled
    by dividing each variable by its sample standard deviation.  If
    cross-validation is selected, scaling by the standard deviation is
    done for every segment.}

\item{validation}{character.  What kind of (internal) validation to
    use.  See below.}

\item{cv.data}{Whether to cross-validate the dataset into training and
testing sets.}

\item{cv.seed}{Seed to set for cv.data.}

\item{paired}{a logical indicating whether you want a paired
    t-test.}
}
\value{
Settings for the analysis are added to the blueprint
}
\description{
Most statistical techniques need to specify some settings for them to run.
This function sets those settings in the blueprint, before the statistical
method is used at the construction phase.
}
\examples{

\dontrun{
design(iris, 'gee') \%>\%
 add_settings('Species', family = binomial('logit'), conf.int = FALSE)

ds <- design(iris, 'cor')
ds <- add_settings(ds, method = 'spearman')

ds <- design(iris, 't.test')
add_settings(ds, paired = TRUE)
add_settings(ds)
}

}
