% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_apply.R
\name{mat_apply}
\alias{mat_apply}
\alias{mat_apply.figure}
\title{Apply rule to generate a matriks (method)}
\usage{
mat_apply(Sq1, hrules = "identity", vrules = "identity", mat.type = 9)

\method{mat_apply}{figure}(Sq1, hrules = "identity", vrules = "identity", mat.type = 9)
}
\arguments{
\item{Sq1}{the figure(s) on which the rule should be applied for creating the matriks}

\item{hrules}{character, the rule(s) to be applied horizontally. Default is identity}

\item{vrules}{character, the rule(s) to be applied vertically. Default is identity}

\item{mat.type}{integer, the type of matriks, either 4-cell matriks or 9-cell matriks (Default is 9)}
}
\value{
A list of length 7 (4-cell matriks) or of length 12 (9-cell matriks)

An object of class matriks of length 7 (4-cell matriks) or of length 12 (9-cell matriks)
}
\description{
Apply a rule or a set of rules to a figure to create a matriks
}
\section{Methods (by class)}{
\itemize{
\item \code{mat_apply(figure)}: Apply rule to generate a matriks (method)

Apply a rule or a set of rules to a figure to create a matriks

}}
\examples{
# apply the size rule on a triangle for creating a matriks with 9 cell
my_mat <- mat_apply(triangle(), mat.type = 9, hrule = "size")
# apply the size rule on a triangle for creating a matriks with 9 cell
my_mat <- mat_apply(triangle(), mat.type = 9, hrule = "size")
}
