/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.precedences;

import choco.cp.solver.constraints.global.tree.filtering.AbstractPropagator;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.precedences.TopologicSort;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.solver.ContradictionException;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Vector;

public class Precedences
extends AbstractPropagator {
    public Precedences(Object[] params) {
        super(params);
    }

    @Override
    public String getTypePropag() {
        return "Precedences propagation";
    }

    @Override
    public boolean feasibility() {
        int m;
        boolean res = true;
        for (m = 0; m < this.nbVertices && res; ++m) {
            BitSet desc = this.precs.getDescendants(m);
            IStateBitSet desc_m = this.inputGraph.getGlobal().getDescendants(m);
            int i = desc.nextSetBit(0);
            while (i >= 0) {
                if (!desc_m.get(i)) {
                    res = false;
                }
                i = desc.nextSetBit(i + 1);
            }
        }
        if (!res) {
            int v = m - 1;
            if (this.affiche) {
                LOGGER.info("2- Violation hasse: pour " + v + " dans V, les " + this.precs.showDesc(v) + " ne sont pas dans les " + this.inputGraph.getGlobal().showDesc(v, "G"));
            }
            return false;
        }
        for (int i = 0; i < this.nbVertices; ++i) {
            if (!this.inputGraph.getSure().getSuccessors(i).get(i) || this.precs.getSinkNodes().get(i)) continue;
            if (this.affiche) {
                LOGGER.info("3- Violation hasse");
            }
            return false;
        }
        return true;
    }

    @Override
    public void filter() throws ContradictionException {
        int i;
        int j;
        int i2;
        int i3;
        for (i3 = 0; i3 < this.nbVertices; ++i3) {
            IStateBitSet possible = this.inputGraph.getMaybe().getSuccessors(i3);
            int j2 = possible.nextSetBit(0);
            while (j2 >= 0) {
                int[] arc = new int[]{i3, j2};
                if (i3 != j2) {
                    if (this.affiche) {
                        LOGGER.info("test arc (" + i3 + "," + j2 + ") ");
                    }
                    if (!this.isCompatible(arc)) {
                        if (this.affiche) {
                            LOGGER.info("Precedences-0: suppression de l'arc (" + i3 + "," + j2 + ")");
                        }
                        this.propagateStruct.addRemoval(arc);
                    }
                } else if (this.precs.getSuccessors(i3).cardinality() > 0) {
                    if (this.affiche) {
                        LOGGER.info("Precedences-1: suppression de l'arc (" + i3 + "," + j2 + ")");
                    }
                    this.propagateStruct.addRemoval(arc);
                }
                j2 = possible.nextSetBit(j2 + 1);
            }
        }
        for (i3 = 0; i3 < this.nbVertices; ++i3) {
            IStateBitSet succ_i = this.inputGraph.getGlobal().getSuccessors(i3);
            BitSet desc_i = this.precs.getDescendants(i3);
            int j3 = succ_i.nextSetBit(0);
            while (j3 >= 0) {
                if (i3 != j3) {
                    BitSet desc_j = this.inputGraph.getGlobal().getDescendants(j3).copyToBitSet();
                    if (this.affiche) {
                        LOGGER.info("Pdesc_" + i3 + " = " + desc_i.toString());
                        LOGGER.info("Mdesc_" + j3 + " = " + desc_j.toString());
                    }
                    desc_j.and(desc_i);
                    desc_j.set(i3, false);
                    if (this.affiche) {
                        LOGGER.info("inter = " + desc_i.toString());
                    }
                    if (desc_j.cardinality() < desc_i.cardinality() - 1) {
                        if (this.affiche) {
                            LOGGER.info("inter[" + i3 + "," + j3 + "] = " + desc_j.toString());
                            LOGGER.info("Precedences-2: suppression de l'arc (" + i3 + "," + j3 + ")");
                        }
                        int[] arc = new int[]{i3, j3};
                        this.propagateStruct.addRemoval(arc);
                    }
                    if (this.affiche) {
                        LOGGER.info("------------------------------");
                    }
                }
                j3 = succ_i.nextSetBit(j3 + 1);
            }
        }
        IStateBitSet roots = this.inputGraph.getPotentialRoots();
        int i4 = roots.nextSetBit(0);
        while (i4 >= 0) {
            if (!this.precs.getSinkNodes().get(i4)) {
                if (this.affiche) {
                    LOGGER.info("Precedences-3: suppression boucle sur " + i4);
                }
                int[] arc = new int[]{i4, i4};
                this.propagateStruct.addRemoval(arc);
            }
            i4 = roots.nextSetBit(i4 + 1);
        }
        BitSet sources = this.precs.getSrcNodes().copyToBitSet();
        BitSet[] markedH = new BitSet[this.nbVertices];
        for (i2 = 0; i2 < this.nbVertices; ++i2) {
            markedH[i2] = new BitSet(this.nbVertices);
        }
        i2 = sources.nextSetBit(0);
        while (i2 >= 0) {
            int j4 = this.precs.getDescendants(i2).nextSetBit(0);
            while (j4 >= 0) {
                markedH[j4].set(i2, true);
                j4 = this.precs.getDescendants(i2).nextSetBit(j4 + 1);
            }
            i2 = sources.nextSetBit(i2 + 1);
        }
        Vector<IStateBitSet> CFC = this.inputGraph.getReducedGraph().getCFC();
        TopologicSort ts = new TopologicSort(this.inputGraph.getReducedGraph().getCFCgraph());
        IStateBitSet[] reducedGraph = this.inputGraph.getReducedGraph().getCFCgraph();
        int[] numTable = ts.sort();
        BitSet[] containG_r = new BitSet[reducedGraph.length];
        for (int i5 = 0; i5 < containG_r.length; ++i5) {
            containG_r[i5] = new BitSet(this.nbVertices);
            containG_r[i5] = CFC.elementAt(i5).copyToBitSet();
        }
        BitSet[] markedG_r = new BitSet[reducedGraph.length];
        for (int i6 = 0; i6 < reducedGraph.length; ++i6) {
            markedG_r[i6] = new BitSet(this.nbVertices);
            int j5 = containG_r[i6].nextSetBit(0);
            while (j5 >= 0) {
                markedG_r[i6].or(markedH[j5]);
                j5 = containG_r[i6].nextSetBit(j5 + 1);
            }
        }
        BitSet[] falseReducedGraph = new BitSet[reducedGraph.length];
        for (int i7 = 0; i7 < falseReducedGraph.length; ++i7) {
            falseReducedGraph[i7] = new BitSet(falseReducedGraph.length);
        }
        while (sources.cardinality() > 0) {
            int currentSRC = -1;
            int start = -1;
            int i8 = 0;
            while (i8 < reducedGraph.length) {
                int j6 = containG_r[i8].nextSetBit(0);
                while (j6 >= 0) {
                    if (sources.get(j6)) {
                        currentSRC = j6;
                        sources.set(currentSRC, false);
                    }
                    j6 = containG_r[i8].nextSetBit(j6 + 1);
                }
                start = i8++;
            }
            if (start == -1 || currentSRC == -1) {
                LOGGER.info("PROBLEME: treeConstraint.filtering.structuralFiltering.precedences.Precedences (line 209)");
                return;
            }
            int[] numPre = this.DFS(start, reducedGraph, numTable, markedG_r, currentSRC);
            for (int u = 0; u < reducedGraph.length; ++u) {
                int v = reducedGraph[u].nextSetBit(0);
                while (v >= 0) {
                    if (numPre[u] < numPre[v] + 1) {
                        int w = reducedGraph[u].nextSetBit(0);
                        while (w >= 0) {
                            if (numPre[w] < numPre[v] && markedG_r[w].get(currentSRC)) {
                                falseReducedGraph[u].set(v, false);
                            }
                            w = reducedGraph[u].nextSetBit(w + 1);
                        }
                    }
                    v = reducedGraph[u].nextSetBit(v + 1);
                }
            }
        }
        for (int u = 0; u < falseReducedGraph.length; ++u) {
            int v = falseReducedGraph[u].nextSetBit(0);
            while (v >= 0) {
                IStateBitSet contain_u = CFC.elementAt(u);
                IStateBitSet contain_v = CFC.elementAt(v);
                int i9 = contain_u.nextSetBit(0);
                while (i9 >= 0) {
                    IStateBitSet succ_i = this.inputGraph.getGlobal().getSuccessors(i9);
                    j = succ_i.nextSetBit(0);
                    while (j >= 0) {
                        if (contain_v.get(j) && !this.propagateStruct.getGraphRem()[i9].get(j)) {
                            if (this.affiche) {
                                LOGGER.info("Precedences-5: suppression de l'arc (" + i9 + "," + j + ")");
                            }
                            int[] arc = new int[]{i9, j};
                            this.propagateStruct.addRemoval(arc);
                        }
                        j = succ_i.nextSetBit(j + 1);
                    }
                    i9 = contain_u.nextSetBit(i9 + 1);
                }
                v = falseReducedGraph[u].nextSetBit(v + 1);
            }
        }
        BitSet[] undirectedHasse = new BitSet[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            undirectedHasse[i] = new BitSet(this.nbVertices);
        }
        for (i = 0; i < this.nbVertices; ++i) {
            IStateBitSet u = this.precs.getSuccessors(i);
            int j7 = u.nextSetBit(0);
            while (j7 >= 0) {
                undirectedHasse[i].set(j7, true);
                undirectedHasse[j7].set(i, true);
                j7 = u.nextSetBit(j7 + 1);
            }
        }
        IStateBitSet[] vertFromNum = this.precs.getVertFromNumCC();
        BitSet out = new BitSet(vertFromNum.length);
        for (int i10 = 0; i10 < vertFromNum.length; ++i10) {
            IStateBitSet vertices = vertFromNum[i10];
            boolean exists = false;
            j = vertices.nextSetBit(0);
            while (j >= 0) {
                IStateBitSet succ = this.precs.getSuccessors(j);
                boolean b = true;
                int k = succ.nextSetBit(0);
                while (k >= 0) {
                    if (vertices.get(k)) {
                        b = false;
                    }
                    k = succ.nextSetBit(k + 1);
                }
                if (b) {
                    exists = true;
                }
                j = vertices.nextSetBit(j + 1);
            }
            if (exists) continue;
            out.set(i10, true);
        }
        int sum_out = out.cardinality();
        int maxtree = vertFromNum.length - sum_out;
        int oldmax = this.tree.getNtree().getSup();
        if (oldmax > maxtree && this.tree.getNtree().getSup() > maxtree) {
            if (this.affiche) {
                LOGGER.info("Precedences: updateSup ntree = " + this.tree.getNtree().getSup() + " ==> " + maxtree);
            }
            this.propagateStruct.setMaxNtree(maxtree);
        }
    }

    private boolean isCompatible(int[] arc) {
        boolean cycle = false;
        boolean transitive = false;
        int src = arc[0];
        int dest = arc[1];
        if (src == dest) {
            if (this.affiche) {
                LOGGER.info("\t(" + src + "," + dest + ") incompatible dans Gp");
            }
            return false;
        }
        BitSet desc_1 = this.precs.getDescendants(dest);
        if (this.affiche) {
            LOGGER.info("desc_" + dest + " = " + desc_1.toString());
        }
        if (desc_1.get(src)) {
            cycle = true;
        }
        if (!cycle) {
            BitSet desc_2 = this.precs.getDescendants(src);
            if (desc_2.get(dest) && !this.precs.getSuccessors(src).get(dest)) {
                if (this.affiche) {
                    LOGGER.info("\ttransitif");
                }
                transitive = true;
            }
            return !transitive;
        }
        if (this.affiche) {
            LOGGER.info("\tcycle");
        }
        return false;
    }

    private int[] DFS(int start, IStateBitSet[] graph, int[] sortLVL, BitSet[] marked, int origin) {
        int cpt = 0;
        int[] numPre = new int[graph.length];
        for (int i = 0; i < numPre.length; ++i) {
            numPre[i] = -1;
        }
        LinkedList<Integer> toVisit = new LinkedList<Integer>();
        LinkedList<Integer> visited = new LinkedList<Integer>();
        visited.offer(start);
        toVisit.addFirst(start);
        while (toVisit.size() != 0) {
            int current = (Integer)toVisit.poll();
            numPre[current] = cpt++;
            IStateBitSet succ = graph[current];
            BitSet minlvl = new BitSet(graph.length);
            int lvl = graph.length;
            int i = succ.nextSetBit(0);
            while (i >= 0) {
                if (!visited.contains(i) && sortLVL[i] < lvl) {
                    minlvl.clear();
                    minlvl.set(i, true);
                    lvl = sortLVL[i];
                } else if (!visited.contains(i) && sortLVL[i] == lvl) {
                    minlvl.set(i, true);
                }
                i = succ.nextSetBit(i + 1);
            }
            i = minlvl.nextSetBit(0);
            while (i >= 0) {
                if (marked[i].get(origin)) {
                    visited.offer(i);
                    toVisit.addFirst(i);
                    minlvl.set(i, false);
                }
                i = minlvl.nextSetBit(i + 1);
            }
            i = minlvl.nextSetBit(0);
            while (i >= 0) {
                visited.offer(i);
                toVisit.addFirst(i);
                i = minlvl.nextSetBit(i + 1);
            }
        }
        return numPre;
    }
}

