/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.cnf;

import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.model.constraints.cnf.ALogicTree;
import choco.kernel.model.constraints.cnf.Literal;
import choco.kernel.model.variables.integer.IntegerVariable;

public final class Node
extends ALogicTree {
    ALogicTree.Operator operator;
    ALogicTree[] children;
    IntegerVariable[] varsAsArray;

    protected Node(ALogicTree.Operator operator, ALogicTree.Type type, ALogicTree ... children) {
        super(type);
        this.operator = operator;
        this.children = children == null ? new ALogicTree[0] : children;
    }

    public static Node and(ALogicTree ... children) {
        return new Node(ALogicTree.Operator.AND, ALogicTree.Type.POSITIVE, children);
    }

    public static Node ifOnlyIf(ALogicTree a, ALogicTree b) {
        return Node.and(Node.implies(a, b), Node.implies(b, a));
    }

    public static Node reified(Literal b, ALogicTree tree) {
        Literal nb = null;
        ALogicTree ntree = null;
        try {
            nb = b.clone();
            nb.type = ALogicTree.Type.flip(b.type);
            ntree = tree.clone();
            ntree.type = ALogicTree.Type.flip(tree.type);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return Node.or(Node.and(b, tree), Node.and(nb, ntree));
    }

    public static Node ifThenElse(ALogicTree a, ALogicTree b, ALogicTree c) {
        try {
            ALogicTree na = a.clone();
            na.type = ALogicTree.Type.flip(a.type);
            return Node.or(Node.and(a, b), Node.and(na, c));
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Node implies(ALogicTree a, ALogicTree b) {
        try {
            ALogicTree na = a.clone();
            na.type = ALogicTree.Type.flip(a.type);
            return Node.or(na, b);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Node or(ALogicTree ... children) {
        return new Node(ALogicTree.Operator.OR, ALogicTree.Type.POSITIVE, children);
    }

    public static Node nand(ALogicTree ... children) {
        return new Node(ALogicTree.Operator.AND, ALogicTree.Type.NEGATIVE, children);
    }

    public static Node nor(ALogicTree ... children) {
        return new Node(ALogicTree.Operator.OR, ALogicTree.Type.NEGATIVE, children);
    }

    public static Node xor(ALogicTree a, ALogicTree b) {
        try {
            ALogicTree na = a.clone();
            ALogicTree nb = b.clone();
            na.type = ALogicTree.Type.flip(a.type);
            nb.type = ALogicTree.Type.flip(b.type);
            return Node.or(Node.and(a, nb), Node.and(b, na));
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean is(ALogicTree.Operator op) {
        return op.equals((Object)this.operator);
    }

    @Override
    boolean isNot() {
        return this.type.equals((Object)ALogicTree.Type.NEGATIVE);
    }

    @Override
    boolean isLit() {
        return false;
    }

    @Override
    int getNbChildren() {
        return this.children.length;
    }

    @Override
    boolean hasOrChild() {
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].is(ALogicTree.Operator.OR)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean hasAndChild() {
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].is(ALogicTree.Operator.AND)) continue;
            return true;
        }
        return false;
    }

    @Override
    void addChild(ALogicTree child) {
        ALogicTree[] tmp = this.children;
        this.children = new ALogicTree[tmp.length + 1];
        System.arraycopy(tmp, 0, this.children, 0, tmp.length);
        this.children[tmp.length] = child;
        this.varsAsArray = null;
    }

    @Override
    void removeChild(ALogicTree child) {
        int i;
        for (i = 0; i < this.children.length && this.children[i] != child; ++i) {
        }
        if (i == this.children.length) {
            return;
        }
        ALogicTree[] tmp = this.children;
        this.children = new ALogicTree[tmp.length - 1];
        System.arraycopy(tmp, 0, this.children, 0, i);
        System.arraycopy(tmp, i + 1, this.children, i, tmp.length - i - 1);
        this.varsAsArray = null;
    }

    @Override
    public ALogicTree[] getChildren() {
        return this.children;
    }

    @Override
    ALogicTree getAndChild() {
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].is(ALogicTree.Operator.AND)) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    ALogicTree getChildBut(ALogicTree child) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == child) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    void flip() {
        this.type = ALogicTree.Type.flip(this.type);
        this.operator = ALogicTree.Operator.flip(this.operator);
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].deny();
        }
    }

    @Override
    void deny() {
        this.operator = ALogicTree.Operator.flip(this.operator);
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].deny();
        }
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append('(');
        String op = (ALogicTree.Type.POSITIVE.equals((Object)this.type) ? "" : "n") + (ALogicTree.Operator.AND.equals((Object)this.operator) ? "and " : "or ");
        for (int i = 0; i < this.children.length; ++i) {
            ALogicTree child = this.children[i];
            st.append(child.toString()).append(" ").append(op);
        }
        st.replace(st.length() - (op.length() + 1), st.length(), "");
        st.append(')');
        return st.toString();
    }

    @Override
    public Node clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        node.type = this.type;
        node.operator = this.operator;
        node.children = new ALogicTree[this.children.length];
        for (int c = 0; c < this.children.length; ++c) {
            node.children[c] = this.children[c].clone();
        }
        return node;
    }

    @Override
    public IntegerVariable[] flattenBoolVar() {
        if (this.varsAsArray == null) {
            this.buildVarsArray();
        }
        return this.varsAsArray;
    }

    private void buildVarsArray() {
        IntegerVariable[][] childrenVars = new IntegerVariable[this.children.length][];
        for (int i = 0; i < this.children.length; ++i) {
            childrenVars[i] = this.children[i].flattenBoolVar();
        }
        this.varsAsArray = ArrayUtils.flatten(childrenVars);
    }

    @Override
    public int getNbPositiveLiterals() {
        int sum = 0;
        for (int c = 0; c < this.children.length; ++c) {
            sum += this.children[c].getNbPositiveLiterals();
        }
        return sum;
    }
}

