/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.iterators.PSIVIterator;

public final class PartiallyStoredIntVector {
    private int[] staticInts = new int[16];
    private int[] storedInts = new int[16];
    private int nStaticInts = 0;
    private final IStateInt nStoredInts;
    private PSIVIterator _iterator;

    public PartiallyStoredIntVector(IEnvironment env) {
        this.nStoredInts = env.makeInt(0);
    }

    public int staticAdd(int o) {
        this.ensureStaticCapacity(this.nStaticInts + 1);
        this.staticInts[this.nStaticInts++] = o;
        return this.nStaticInts - 1;
    }

    public void ensureStaticCapacity(int n) {
        if (n > this.staticInts.length) {
            int newSize = this.staticInts.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            int[] newStaticObjects = new int[newSize];
            System.arraycopy(this.staticInts, 0, newStaticObjects, 0, this.staticInts.length);
            this.staticInts = newStaticObjects;
        }
    }

    public int add(int o) {
        this.ensureStoredCapacity(this.nStoredInts.get() + 1);
        this.storedInts[this.nStoredInts.get()] = o;
        this.nStoredInts.add(1);
        return 1000000 + this.nStoredInts.get() - 1;
    }

    public void remove(int o) {
        this.staticInts[o] = this.staticInts[this.nStaticInts];
        this.staticInts[this.nStaticInts] = 0;
        --this.nStaticInts;
    }

    public void ensureStoredCapacity(int n) {
        if (n > this.storedInts.length) {
            int newSize = this.storedInts.length;
            while (n >= newSize) {
                newSize = newSize * 3 / 2 + 1;
            }
            int[] newStoredObjects = new int[newSize];
            System.arraycopy(this.storedInts, 0, newStoredObjects, 0, this.storedInts.length);
            this.storedInts = newStoredObjects;
        }
    }

    public int get(int index) {
        if (index < 1000000) {
            return this.staticInts[index];
        }
        return this.storedInts[index - 1000000];
    }

    public boolean isEmpty() {
        return this.nStaticInts == 0 && this.nStoredInts.get() == 0;
    }

    public int size() {
        return this.nStaticInts + this.nStoredInts.get();
    }

    public DisposableIntIterator getIndexIterator() {
        if (this._iterator == null) {
            this._iterator = new PSIVIterator();
        } else if (!this._iterator.reusable()) {
            assert (false);
            this._iterator = new PSIVIterator();
        }
        this._iterator.init(this.nStaticInts, this.nStoredInts);
        return this._iterator;
    }

    public static boolean isStaticIndex(int idx) {
        return idx < 1000000;
    }

    public static int getSmallIndex(int idx) {
        if (idx < 1000000) {
            return idx;
        }
        return idx - 1000000;
    }

    public static int getGlobalIndex(int idx, boolean isStatic) {
        if (isStatic) {
            return idx;
        }
        return idx + 1000000;
    }
}

