/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.inputStructure;

import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.List;

public class TreeParameters {
    protected Solver solver;
    protected int nbNodes;
    protected Node[] nodes;
    protected IntDomainVar ntree;
    protected IntDomainVar nproper;
    protected IntDomainVar objective;
    protected IStateInt[][] travelTime;

    public TreeParameters(Solver solver, int nbNodes, IntDomainVar ntree, IntDomainVar nproper, IntDomainVar objective, List<BitSet[]> graphs, List<int[][]> matrix, int[][] travel) throws ContradictionException {
        int i;
        this.solver = solver;
        this.nbNodes = nbNodes;
        this.ntree = ntree;
        this.nproper = nproper;
        this.objective = objective;
        this.nodes = new Node[this.nbNodes];
        this.travelTime = new IStateInt[this.nbNodes][this.nbNodes];
        for (i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                this.travelTime[i][j] = solver.getEnvironment().makeInt(travel[i][j]);
            }
        }
        for (i = 0; i < this.nbNodes; ++i) {
            this.nodes[i] = new Node(solver, nbNodes, i, graphs, matrix);
        }
    }

    public TreeParameters(Solver solver, int nbNodes, IntDomainVar ntree, IntDomainVar nproper, IntDomainVar objective, Node[] nodes, int[][] travel) {
        this.solver = solver;
        this.nbNodes = nbNodes;
        this.ntree = ntree;
        this.nproper = nproper;
        this.objective = objective;
        this.nodes = nodes;
        this.travelTime = new IStateInt[this.nbNodes][this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                this.travelTime[i][j] = solver.getEnvironment().makeInt(travel[i][j]);
            }
        }
    }

    public IntDomainVar[] getAllVars() {
        int i;
        IntDomainVar[] tab = new IntDomainVar[3 * this.nbNodes + 3];
        tab[0] = this.ntree;
        tab[1] = this.nproper;
        tab[2] = this.objective;
        int idx = 3;
        for (i = 0; i < this.nbNodes; ++i) {
            tab[idx++] = this.nodes[i].getSuccessors();
        }
        for (i = 0; i < this.nbNodes; ++i) {
            tab[idx++] = this.nodes[i].getTimeWindow();
        }
        for (i = 0; i < this.nbNodes; ++i) {
            tab[idx++] = this.nodes[i].getInDegree();
        }
        return tab;
    }

    public IntDomainVar[] getSuccVars() {
        IntDomainVar[] tab = new IntDomainVar[this.nbNodes];
        int idx = 0;
        for (int i = 0; i < this.nbNodes; ++i) {
            tab[idx++] = this.nodes[i].getSuccessors();
        }
        return tab;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public int getNbNodes() {
        return this.nbNodes;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public IntDomainVar getNtree() {
        return this.ntree;
    }

    public IntDomainVar getNproper() {
        return this.nproper;
    }

    public IntDomainVar getObjective() {
        return this.objective;
    }

    public IStateInt[][] getTravelTime() {
        return this.travelTime;
    }
}

