/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer.extension;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class CspBinSConstraint
extends AbstractBinIntSConstraint {
    protected BinRelation relation;

    protected CspBinSConstraint(IntDomainVar x, IntDomainVar y, BinRelation relation) {
        super(x, y);
        this.relation = relation;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.relation.isConsistent(tuple[0], tuple[1]);
    }

    public BinRelation getRelation() {
        return this.relation;
    }

    @Override
    public Boolean isEntailed() {
        int nbCons = 0;
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        while (itv0.hasNext()) {
            int val = itv0.next();
            int nbS = 0;
            DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
            while (itv1.hasNext()) {
                if (!this.relation.isConsistent(val, itv1.next())) continue;
                ++nbS;
            }
            if (nbS > 0 && nbS < this.v1.getDomainSize()) {
                return null;
            }
            nbCons += nbS;
        }
        itv0.dispose();
        if (nbCons == 0) {
            return Boolean.FALSE;
        }
        if (nbCons == this.v0.getDomainSize() * this.v1.getDomainSize()) {
            return Boolean.TRUE;
        }
        return null;
    }
}

