/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.geometricPrim;

import choco.kernel.common.logging.ChocoLogging;
import java.io.Serializable;
import java.util.logging.Logger;

public final class Point
implements Serializable {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private int[] coords;
    private int dim;

    public void print() {
        for (int i = 0; i < this.dim; ++i) {
            LOGGER.info(this.coords[i] + " ");
        }
    }

    public Point(int dim) {
        this.dim = dim;
        this.coords = new int[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.coords[i] = 0;
        }
    }

    public Point(int[] coordinates) {
        this.dim = coordinates.length;
        this.coords = new int[this.dim];
        this.dim = coordinates.length;
        this.setCoords(coordinates);
    }

    public Point(Point p) {
        this.dim = p.getCoords().length;
        this.coords = new int[this.dim];
        for (int i = 0; i < p.getCoords().length; ++i) {
            this.coords[i] = p.getCoord(i);
        }
    }

    public int[] getCoords() {
        return this.coords;
    }

    public void setCoords(int[] coordinates) {
        System.arraycopy(coordinates, 0, this.coords, 0, coordinates.length);
    }

    public int getCoord(int index) {
        return this.coords[index];
    }

    public void setCoord(int index, int value) {
        this.coords[index] = value;
    }

    public boolean lexGreaterThanOrEqual(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) >= other.getCoord(jPrime);
        }
        return true;
    }

    public boolean equalTo(Point other) {
        for (int j = 0; j < this.dim; ++j) {
            if (this.getCoord(j) == other.getCoord(j)) continue;
            return false;
        }
        return true;
    }

    public boolean lexGreaterThan(Point other, int[] ctrlV) {
        for (int i = 0; i < this.dim; ++i) {
            boolean positive;
            int actualDim = Math.abs(ctrlV[i + 1]) - 2;
            boolean bl = positive = ctrlV[i + 1] > 0;
            if (this.getCoord(actualDim) == other.getCoord(actualDim)) continue;
            if (positive) {
                return this.getCoord(actualDim) < other.getCoord(actualDim);
            }
            return this.getCoord(actualDim) > other.getCoord(actualDim);
        }
        return false;
    }

    public boolean lexGreaterThan(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) >= other.getCoord(jPrime);
        }
        return false;
    }

    public boolean lexLessThanOrEqual(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) <= other.getCoord(jPrime);
        }
        return true;
    }

    public boolean lexLessThan(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) <= other.getCoord(jPrime);
        }
        return false;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("(");
        for (int i = 0; i < this.dim; ++i) {
            if (i != this.dim - 1) {
                res.append(this.coords[i]).append(",");
                continue;
            }
            res.append(this.coords[i]).append(")");
        }
        return res.toString();
    }
}

