/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints;

import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.variables.Var;
import java.util.Arrays;
import java.util.HashMap;

public abstract class AbstractSConstraint<V extends Var>
extends Propagator
implements SConstraint<V> {
    protected V[] vars;
    public int[] cIndices;
    protected SConstraintType constraintType;
    private static int ABSTRACTSCONSTRAINT_EXTENSIONS_NB = 0;
    private static final HashMap<String, Integer> REGISTERED_ABSTRACTSCONSTRAINT_EXTENSIONS = new HashMap();
    public Extension[] extensions = new Extension[1];

    public static int getAbstractSConstraintExtensionNumber(String name) {
        Integer index = REGISTERED_ABSTRACTSCONSTRAINT_EXTENSIONS.get(name);
        if (index == null) {
            index = ABSTRACTSCONSTRAINT_EXTENSIONS_NB++;
            REGISTERED_ABSTRACTSCONSTRAINT_EXTENSIONS.put(name, index);
        }
        return index;
    }

    protected AbstractSConstraint(V[] vars) {
        this.vars = vars;
        this.cIndices = new int[vars.length];
    }

    protected AbstractSConstraint(int priority, V[] vars) {
        super(priority);
        this.vars = vars;
        this.cIndices = new int[vars.length];
    }

    private boolean rangeCheck(int i) {
        return i >= 0 && i < this.vars.length;
    }

    @Override
    public void addExtension(int extensionNumber) {
        if (extensionNumber > this.extensions.length) {
            Extension[] newArray = new Extension[this.extensions.length * 2];
            System.arraycopy(this.extensions, 0, newArray, 0, this.extensions.length);
            this.extensions = newArray;
        }
        this.extensions[extensionNumber] = new Extension();
    }

    @Override
    public final Extension getExtension(int extensionNumber) {
        return this.extensions[extensionNumber];
    }

    public final void setExtension(Extension ext, int extensionNumber) {
        if (extensionNumber > this.extensions.length) {
            Extension[] newArray = new Extension[this.extensions.length * 2];
            System.arraycopy(this.extensions, 0, newArray, 0, this.extensions.length);
            this.extensions = newArray;
        }
        this.extensions[extensionNumber] = ext;
    }

    @Override
    public Boolean isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return this.isSatisfied();
        }
        return null;
    }

    @Override
    public void addListener(boolean dynamicAddition) {
        int n = this.getNbVars();
        for (int i = 0; i < n; ++i) {
            this.setConstraintIndex(i, this.getVar(i).addConstraint(this, i, dynamicAddition));
            this.getVar(i).getEvent().addPropagatedEvents(this.getFilteredEventMask(i));
        }
    }

    @Override
    public final void setConstraintIndex(int i, int val) {
        if (!this.rangeCheck(i)) {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
        this.cIndices[i] = val;
    }

    @Override
    public final int getConstraintIdx(int i) {
        return this.rangeCheck(i) ? this.cIndices[i] : -1;
    }

    @Override
    public final boolean isCompletelyInstantiated() {
        int nVariables = this.vars.length;
        for (int i = 0; i < nVariables; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int getNbVars() {
        return this.vars.length;
    }

    @Override
    public final V getVar(int i) {
        return this.rangeCheck(i) ? (V)this.vars[i] : null;
    }

    @Override
    public final V getVarQuick(int i) {
        return this.vars[i];
    }

    @Override
    public final void setVar(int i, V v) {
        if (!this.rangeCheck(i)) {
            throw new SolverException("BUG in CSP network management: too large index for setVar");
        }
        this.vars[i] = v;
    }

    @Override
    public AbstractSConstraint<V> opposite(Solver solver) {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractSConstraint newc = (AbstractSConstraint)super.clone();
        newc.vars = (Var[])Arrays.copyOf(this.vars, this.vars.length);
        newc.cIndices = Arrays.copyOf(this.cIndices, this.cIndices.length);
        return newc;
    }

    public final int getNbVarNotInst() {
        int notInst = 0;
        int nbVars = this.getNbVars();
        for (int i = 0; i < nbVars; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            ++notInst;
        }
        return notInst;
    }

    public String toString() {
        return this.pretty();
    }

    @Override
    public String pretty() {
        return this.getClass().getSimpleName() + Arrays.toString(this.vars);
    }

    @Override
    public int getFineDegree(int idx) {
        return 1;
    }
}

