/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.cp.solver.constraints.global.scheduling.RTask;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.HTask;

public class BoundHRTask
extends RTask {
    protected final IStateInt estH;
    protected final IStateInt lctH;

    public BoundHRTask(IEnvironment env, AbstractResourceSConstraint constraint, int taskIdx) {
        super(constraint, taskIdx);
        this.estH = env.makeInt(this.getTaskVar().getEST());
        this.lctH = env.makeInt(this.getTaskVar().getLCT());
        this.htask = new HTask(this.taskvar, this.usage, this.estH, this.lctH);
    }

    public void fireHypotheticalDomain() {
        this.getTaskVar().updateHypotheticalDomain(-1, null, false);
    }

    public final boolean checkHypotheticalConsistency() {
        return this.htask.getLCT() - this.htask.getEST() >= this.htask.getMinDuration();
    }

    protected void checkHConsistency() throws ContradictionException {
        if (!this.checkHypotheticalConsistency()) {
            this.remove();
            this.fireRemoval();
        }
    }

    @Override
    public void checkConsistency() throws ContradictionException {
        super.checkConsistency();
        if (this.isOptional()) {
            this.checkHConsistency();
        }
    }

    @Override
    public final boolean assign() throws ContradictionException {
        boolean assigned = super.assign();
        if (super.setEST(this.estH.get()) || super.setLCT(this.lctH.get())) {
            this.updateCompulsoryPart();
        }
        return assigned;
    }

    protected boolean setHEST(int val) throws ContradictionException {
        if (val > this.htask.getEST()) {
            this.estH.set(val);
            this.checkHConsistency();
            this.fireHypotheticalDomain();
            return true;
        }
        return false;
    }

    @Override
    public final boolean setEST(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHEST(val);
        }
        return super.setEST(val);
    }

    protected boolean setHDuration(int duration) throws ContradictionException {
        if (this.htask.getLCT() - this.htask.getEST() >= duration) {
            this.remove();
            return true;
        }
        return false;
    }

    @Override
    public final boolean setDuration(int duration) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHDuration(duration);
        }
        return super.setDuration(duration);
    }

    protected boolean setHECT(int val) throws ContradictionException {
        if (val > this.htask.getECT()) {
            this.estH.set(val - this.htask.getMinDuration());
            this.checkHConsistency();
            this.fireHypotheticalDomain();
            return true;
        }
        return false;
    }

    @Override
    public final boolean setECT(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHECT(val);
        }
        return super.setECT(val);
    }

    public final boolean setHEndingTime(int endingTime) throws ContradictionException {
        return this.setHLCT(endingTime) || this.setHECT(endingTime);
    }

    @Override
    public final boolean setEndingTime(int endingTime) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHEndingTime(endingTime);
        }
        return super.setEndingTime(endingTime);
    }

    public final boolean setHEndNotIn(int a, int b) throws ContradictionException {
        if (a <= this.htask.getECT()) {
            return this.setHECT(b);
        }
        if (b >= this.htask.getLCT()) {
            return this.setHLCT(a);
        }
        return false;
    }

    @Override
    public final boolean setEndNotIn(int a, int b) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHEndNotIn(a, b);
        }
        return super.setEndNotIn(a, b);
    }

    protected boolean setHLCT(int val) throws ContradictionException {
        if (val < this.htask.getLCT()) {
            this.lctH.set(val);
            this.checkHConsistency();
            this.fireHypotheticalDomain();
            return true;
        }
        return false;
    }

    @Override
    public final boolean setLCT(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHLCT(val);
        }
        return super.setLCT(val);
    }

    protected boolean setHLST(int val) throws ContradictionException {
        if (val < this.htask.getLST()) {
            this.lctH.set(val + this.htask.getMaxDuration());
            this.checkHConsistency();
            this.fireHypotheticalDomain();
            return true;
        }
        return false;
    }

    @Override
    public final boolean setLST(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHLST(val);
        }
        return super.setLST(val);
    }

    @Override
    public final boolean setMaxDuration(int val) throws ContradictionException {
        if (this.isRegular()) {
            return super.setMaxDuration(val);
        }
        return false;
    }

    @Override
    public final boolean setMinDuration(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHDuration(val);
        }
        return super.setMinDuration(val);
    }

    protected final boolean setHStartingTime(int startingTime) throws ContradictionException {
        return this.setHEST(startingTime) || this.setHLST(startingTime);
    }

    @Override
    public final boolean setStartingTime(int startingTime) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHStartingTime(startingTime);
        }
        return super.setStartingTime(startingTime);
    }

    protected final boolean setHStartNotIn(int min, int max) throws ContradictionException {
        if (min <= this.htask.getEST()) {
            return this.setHEST(max);
        }
        if (max >= this.htask.getLST()) {
            return this.setHLST(min);
        }
        return false;
    }

    @Override
    public final boolean setStartNotIn(int min, int max) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHStartNotIn(min, max);
        }
        return super.setStartNotIn(min, max);
    }

    @Override
    public final boolean updateDuration(int duration) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHDuration(duration);
        }
        return super.updateDuration(duration);
    }

    @Override
    public final boolean updateECT(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHECT(val);
        }
        return super.updateECT(val);
    }

    @Override
    public final boolean updateEndingTime(int endingTime) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHEndingTime(endingTime);
        }
        return super.updateEndingTime(endingTime);
    }

    @Override
    public final boolean updateEndNotIn(int a, int b) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHEndNotIn(a, b);
        }
        return super.updateEndNotIn(a, b);
    }

    @Override
    public final boolean updateEST(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHEST(val);
        }
        return super.updateEST(val);
    }

    @Override
    public final boolean updateLCT(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHLCT(val);
        }
        return super.updateLCT(val);
    }

    @Override
    public final boolean updateLST(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHLST(val);
        }
        return super.updateLST(val);
    }

    @Override
    public final boolean updateMaxDuration(int val) throws ContradictionException {
        if (this.isRegular()) {
            return super.updateMaxDuration(val);
        }
        return false;
    }

    @Override
    public final boolean updateMinDuration(int val) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHDuration(val);
        }
        return super.updateMinDuration(val);
    }

    @Override
    public final boolean updateStartingTime(int startingTime) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHStartingTime(startingTime);
        }
        return super.updateStartingTime(startingTime);
    }

    @Override
    public final boolean updateStartNotIn(int a, int b) throws ContradictionException {
        if (this.isOptional()) {
            return this.setHStartNotIn(a, b);
        }
        return super.updateStartNotIn(a, b);
    }
}

