/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectShortHashMap;
import gnu.trove.TObjectShortIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectShortHashMapDecorator<V>
extends AbstractMap<V, Short>
implements Map<V, Short>,
Externalizable,
Cloneable {
    protected TObjectShortHashMap<V> _map;

    public TObjectShortHashMapDecorator() {
    }

    public TObjectShortHashMapDecorator(TObjectShortHashMap<V> map) {
        this._map = map;
    }

    public TObjectShortHashMap<V> getMap() {
        return this._map;
    }

    @Override
    public TObjectShortHashMapDecorator clone() {
        try {
            TObjectShortHashMapDecorator copy = (TObjectShortHashMapDecorator)super.clone();
            copy._map = this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Short put(V key, Short value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public Short get(Object key) {
        V k = this.unwrapKey(key);
        short v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Short remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<V, Short>> entrySet() {
        return new AbstractSet<Map.Entry<V, Short>>(){

            @Override
            public int size() {
                return TObjectShortHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectShortHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TObjectShortHashMapDecorator.this.containsKey(k) && TObjectShortHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<V, Short>> iterator() {
                return new Iterator<Map.Entry<V, Short>>(){
                    private final TObjectShortIterator<V> it;
                    {
                        this.it = TObjectShortHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<V, Short> next() {
                        this.it.advance();
                        final Object key = TObjectShortHashMapDecorator.this.wrapKey(this.it.key());
                        final Short v = TObjectShortHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<V, Short>(){
                            private Short val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public V getKey() {
                                return key;
                            }

                            @Override
                            public Short getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Short setValue(Short value) {
                                this.val = value;
                                return TObjectShortHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Short o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<V, Short>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectShortHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends V, ? extends Short> map) {
        Iterator<Map.Entry<V, Short>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<V, Short> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected final V wrapKey(Object o) {
        return (V)o;
    }

    protected final V unwrapKey(Object key) {
        return (V)key;
    }

    protected Short wrapValue(short k) {
        return k;
    }

    protected short unwrapValue(Object value) {
        return (Short)value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._map = (TObjectShortHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this._map);
    }
}

