/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.APartiallyStoredCstrList;
import choco.kernel.memory.structure.Couple;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.iterators.PSCLEIterator;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;

public final class PartiallyStoredTaskCstrList<C extends AbstractSConstraint>
extends APartiallyStoredCstrList<C> {
    private final PartiallyStoredIntVector events;
    private final IStateInt priority;
    private PSCLEIterator<C> _iterator;

    public PartiallyStoredTaskCstrList(IEnvironment env) {
        super(env);
        this.events = env.makePartiallyStoredIntVector();
        this.priority = env.makeInt(0);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        int constraintIdx = super.addConstraint(c, varIdx, dynamicAddition);
        AbstractSConstraint ic = (AbstractSConstraint)c;
        int mask = ic.getFilteredEventMask(varIdx);
        if ((mask & 1) != 0) {
            this.addEvent(dynamicAddition, constraintIdx);
        }
        return constraintIdx;
    }

    private void addEvent(boolean dynamicAddition, int constraintIdx) {
        if (dynamicAddition) {
            this.events.add(constraintIdx);
        } else {
            this.events.staticAdd(constraintIdx);
        }
    }

    @Override
    public int eraseConstraint(SConstraint c) {
        int idx = super.eraseConstraint(c);
        int mask = ((AbstractIntSConstraint)c).getFilteredEventMask(this.indices.get(idx));
        if ((mask & 1) != 0) {
            this.events.remove(idx);
        }
        return idx;
    }

    public PartiallyStoredIntVector getEventsVector() {
        return this.events;
    }

    public DisposableIterator<Couple<C>> getActiveConstraint(C cstrCause) {
        if (this._iterator == null || !this._iterator.reusable()) {
            this._iterator = new PSCLEIterator();
        }
        this._iterator.init(cstrCause, this.events, this.elements, this.indices);
        return this._iterator;
    }
}

