% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setUpPopulations.R
\name{makeScene}
\alias{makeScene}
\title{Create a matingScene object from a data frame}
\usage{
makeScene(df, multiYear = FALSE, startCol = "start", endCol = "end",
  xCol = "x", yCol = "y", s1Col = "s1", s2Col = "s2", idCol = "id",
  dateFormat = "\%Y-\%m-\%d")
}
\arguments{
\item{df}{a data frame containing information about a mating scene,
namely coordinate of individuals in space, time, and mating type.}

\item{multiYear}{logical indicating whether or not to split the result into
a list by year}

\item{startCol}{character name of column with start dates}

\item{endCol}{character name of column with end dates}

\item{xCol}{character name of column with x or E coordinates}

\item{yCol}{character name of column with y or N coordinates}

\item{s1Col}{character name of one column with S-allele}

\item{s2Col}{character name of another column with S-alleles}

\item{idCol}{character name for column with unique identifier}

\item{dateFormat}{character indicating either (1) the format of the start and end
date columns if those columns are characters or (2) the origin for the start
and end date columns if those columns are numeric. It is used in as.Date}
}
\value{
a matingScene object, either a single dataframe in standard format
or a list of dataframes. Attributes of the matingScene object indicate the type of
information in the data frame, including the original column names,
and the origin of the date columns. If multiYear = TRUE,
the return value will be a list of matingScene data frames where each
element in the list represents one year. See details for more information
on attributes and how to work with multi-year data.
}
\description{
Turns a data frame with information about temporal, spatial, or
genetic mating data into a matingScene object using a standard format.
}
\details{
The input dataframe can contain information about locations of
individuals in 1, 2, or 3 dimensions of a mating scenes.
The function currently allows two spatial coordinates. The user specifies
the names of the columns and they will be saved xCol and yCol in the
matingScene object. MatingScene objects currently save temporal
coordinates for individuals as start and end date of mating activity
within a year. Mating type coordinates are saved as mating type alleles.
Columns are named id, start, end, x, y, s1, and s2 for
idCol, startCol, endCol, xCol, yCol, s1Col, and s2Col respectively.
The attributes "t", "s", and "mt" will be set to TRUE if the data frame
has temporal, spatial, or mating type data, respectively and
will be FALSE otherwise. The attribute originalNames contains all the
names of the columns in the original data frame.\cr
The start and end columns will be changed to integers relative to the start
day of the population. So the first day of the first individual to become
receptive will be 1 and so on. The attribute origin contains the
origin that can be used when converting the columns start and end
from integers to dates.\cr
If no temporal data are available except the year in which it was
collected and df is a multi-year data set, put the collection year into the
column labelled as startCol and set dateFormat = "%Y" and that will split
the data appropriately.
}
\author{
Danny Hanson
}

