% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potentialPlot.R
\name{plotPotential}
\alias{plotPotential}
\title{graphical visualization of a mating potential object}
\usage{
plotPotential(matPot, subject = c("pair", "ind"), plotType = "auto",
  showDensity = T, sub.ids = NULL, N = 9, sample = "random",
  lab.cex = 0.5, main = NULL, ...)
}
\arguments{
\item{matPot}{a mating potential object}

\item{subject}{a character string indicating whether the subject to be visualized is individuals or all pairwise interactions}

\item{plotType}{a character string indivating the plots to be displayed. Options are histogram ('hist'), network diagram ('net')}

\item{showDensity}{logical. If true (default), plots probability density over histogram.}

\item{sub.ids}{a vector containing the ids of individuals to be represented in pairwise potential plots}

\item{N}{a positive number, the number of individuals to sample if sub.ids = 'random'}

\item{sample}{a character string specifying how to choose a subset of individuals to be represented in pairwise potential plots. Possible values are "random" (default) or "all".}

\item{lab.cex}{parameter indicating label size relative to plot
(different than cex.lab)}

\item{main}{the main title (on top of plot)}

\item{...}{optional arguments for the plot function}
}
\description{
Visualize mating potential
}
\examples{
pop <- simulateScene()
sync <- synchrony(pop, "augs")
plotPotential(sync)


}
\author{
Amy Waananen
}
\seealso{
see generic function \code{\link{points}} for values of \code{pch}
}

