% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corner.R
\name{point_on_line}
\alias{point_on_line}
\title{Position of a point along a line}
\usage{
point_on_line(x1, x2, d, absolute = TRUE)
}
\arguments{
\item{x1}{A vector of length 2 or 3, representing the starting point of a line in  2D or 3D space}

\item{x2}{A vector of length 2 or 3, representing the ending point of a line in  2D or 3D space}

\item{d}{The distance along the line from \code{x1} to \code{x2} of the point to be found}

\item{absolute}{logical; if \code{TRUE}, \code{d} is taken as an absolute distance along the line; otherwise it
is calculated as a relative distance, i.e., a fraction of the length of the line}
}
\value{
The interpolated point, a vector of the same length as \code{x1}
}
\description{
A utility function for drawing vector diagrams. Find position of an interpolated point along a line from \code{x1} to \code{x2}.
}
\examples{
x1 <- c(0, 0)
x2 <- c(1, 4)
point_on_line(x1, x2, 0.5)
point_on_line(x1, x2, 0.5, absolute=FALSE)
point_on_line(x1, x2, 1.1)

y1 <- c(1, 2, 3)
y2 <- c(3, 2, 1)
point_on_line(y1, y2, 0.5)
point_on_line(y1, y2, 0.5, absolute=FALSE)
}
\seealso{
Other vector diagrams: \code{\link{Proj}},
  \code{\link{arrows3d}}, \code{\link{corner}},
  \code{\link{vectors3d}}, \code{\link{vectors}}
}

