% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpower.R
\name{mpower}
\alias{mpower}
\title{Matrix Power}
\usage{
mpower(A, p, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{A}{a square symmetrix matrix}

\item{p}{matrix power, not necessarily a positive integer}

\item{tol}{tolerance for determining if the matrix is symmetric}
}
\value{
\code{A} raised to the power \code{p}: \code{A^p}
}
\description{
A simple function to demonstrate the power of a square symmetrix matrix in terms of its eigenvalues and eigenvectors.
}
\details{
The matrix power \code{p} can be a fraction or other non-integer.  For example, \code{p=1/2} and
     \code{p=1/3} give a square-root and cube-root of the matrix.

     Negative powers are also allowed. For example, \code{p=-1} gives the inverse and \code{p=-1/2}
     gives the inverse square-root.
}
\examples{
C <- matrix(c(1,2,3,2,5,6,3,6,10), 3, 3) # nonsingular, symmetric
C
mpower(C, 2)
zapsmall(mpower(C, -1))
solve(C)    # check
}
\seealso{
The \code{{\%^\%}} operator in the \pkg{expm} package is far more efficient
}

