% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GramSchmidt.R
\name{GramSchmidt}
\alias{GramSchmidt}
\title{Gram-Schmidt Orthogonalization of a Matrix}
\usage{
GramSchmidt(X, normalize = TRUE, verbose = FALSE,
  tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{X}{a matrix}

\item{normalize}{logical; should the resulting columns be normalized to unit length?}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{tol}{the tolerance for detecting linear dependencies in the columns of a. The default is \code{.Machine$double.eps}}
}
\value{
A matrix of the same size as \code{X}, with orthogonal columns
}
\description{
Carries out simple Gram-Schmidt orthogonalization of a matrix.
Treating the columns of the matrix \code{X} in the given order,
each successive column after the first is made orthogonal to all
previous columns by subtracting their projections on the current
column.
}
\examples{
(xx <- matrix(c( 1:3, 3:1, 1, 0, -2), 3, 3))
crossprod(xx)
(zz <- GramSchmidt(xx, normalize=FALSE))
zapsmall(crossprod(zz))

# normalized
(zz <- GramSchmidt(xx))
zapsmall(crossprod(zz))

# print steps
GramSchmidt(xx, verbose=TRUE)

# non-invertible matrix; hence, its basis is not orthonormal
(xx <- matrix(c( 1:3, 3:1, 1, 0, -1), 3, 3))
crossprod(xx)
(zz <- GramSchmidt(xx))
zapsmall(crossprod(zz))

}
\author{
Phil Chalmers, John Fox
}
