% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowops.R
\name{buildTmat}
\alias{buildTmat}
\alias{as.matrix.trace}
\alias{print.trace}
\title{Build/Get transformation matrices}
\usage{
buildTmat(x, all = FALSE)

\method{as.matrix}{trace}(x, ...)

\method{print}{trace}(x, ...)
}
\arguments{
\item{x}{a matrix A, joined with a vector of constants, b, that has been passed to
\code{\link{gaussianElimination}} or the row operator matrix functions}

\item{all}{logical; print individual transformation ies?}

\item{...}{additional arguments}
}
\value{
the transformation matrix or a list of individual transformation matrices
}
\description{
Recover the history of the row operations that have been performed.
This function combines the transformation matrices into a single transformation matrix
representing all row operations or may optionally print all the individual operations which have
been performed.
}
\examples{
A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
b <- c(8, -11, -3)

# using row operations to reduce below diagonal to 0
Abt <- Ab <- cbind(A, b)
Abt <- rowadd(Abt, 1, 2, 3/2)
Abt <- rowadd(Abt, 1, 3, 1)
Abt <- rowadd(Abt, 2, 3, -4)
Abt

# build T matrix and multiply by original form
(T <- buildTmat(Abt))
T \%*\% Ab    # same as Abt

# print all transformation matrices
buildTmat(Abt, TRUE)

# invert transformation matrix to reverse operations
inv(T) \%*\% Abt

# gaussian elimination
(soln <- gaussianElimination(A, b))
T <- buildTmat(soln)
inv(T) \%*\% soln

}
\seealso{
\code{\link{echelon}}, \code{\link{gaussianElimination}}
}
\author{
Phil Chalmers
}
\concept{matrix of elementary row operations}
