% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2latex.R
\name{matrix2latex}
\alias{matrix2latex}
\title{Convert matrix to LaTeX equation}
\usage{
matrix2latex(x, fractions = FALSE, brackets = TRUE, ...)
}
\arguments{
\item{x}{a matrix}

\item{fractions}{logical; if \code{TRUE}, try to express non-integers as rational numbers, using the \code{\link[MASS]{fractions}} 
function; if you require greater accuracy, you can set the \code{cycles} (default 10)
and/or \code{max.denominator} (default 2000) arguments to \code{fractions} as a global option, e.g.,
\code{options(fractions=list(cycles=100, max.denominator=10^4))}.}

\item{brackets}{logical; include square brackets around the matrices?}

\item{...}{additional arguments passed to \code{xtable::xtableMatharray()}}
}
\description{
This function provides a soft-wrapper to \code{xtable::xtableMatharray()} with support for
\code{fraction}s output and square \code{bracket}s.
}
\examples{
A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
b <- c(8, -11, -3)

matrix2latex(cbind(A,b))
matrix2latex(cbind(A,b), digits = 0)
matrix2latex(cbind(A/2,b), fractions = TRUE)

}
\author{
Phil Chalmers
}
