% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\docType{methods}
\name{plotValueSeries}
\alias{plotValueSeries}
\title{Plots the development of the values}
\usage{
plotValueSeries(
  data,
  item,
  item_id,
  value,
  timestamp,
  temporalAggregation = c("day", "week", "month", "quarter", "year"),
  expand = TRUE,
  withTrendLine = TRUE,
  windowLength = 5,
  trendLineType = "s"
)
}
\arguments{
\item{data}{Data frame or matrix on which the ABC analysis is performed.}

\item{item}{Name of the column including the item name or identifier (e.g., product name, EAN).}

\item{item_id}{Name of the item that will be displayed.}

\item{value}{Name of the column variable that contains the values.}

\item{timestamp}{Name of the column including the timestamp. This column should be in POSIX or date-format.}

\item{temporalAggregation}{Temporal aggregation for the XYZ-analysis (i.e., "day", "week", "month", "quarter", "year").}

\item{expand}{Indicator if the data should be expanded with time intervals that have no data.}

\item{withTrendLine}{Indicator if a trend line should be displayed in the bar chart.}

\item{windowLength}{Backwards window length.}

\item{trendLineType}{If "s" the simple and if "w" the weighted moving average is calculated.}
}
\value{
A plotly bar chart, that shows the development of the value column.
}
\description{
Plots a bar chart that shows the sum of the value column for a certain time interval.
}
\examples{
data("Amount")
plotValueSeries(Amount,
                item = "item",
                item_id = "45186",
                value = "amount",
                timestamp = "date",
                temporalAggregation = "week",
                withTrendLine = TRUE,
                windowLength = 10,
                trendLineType = "w")
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
