% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_annotation}
\alias{get_annotation}
\title{Get row annotations.}
\usage{
get_annotation(population, annotation_prefix = "Metadata_")
}
\arguments{
\item{population}{data.frame with annotations (a.k.a. metadata) and
observation variables.}

\item{annotation_prefix}{optional character string specifying prefix for
annotation columns (e.g. \code{"Metadata_"} (default)).}
}
\value{
data.frame with row annotations of the same class as
\code{population}.
}
\description{
\code{get_annotation} gets row annotations.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = c(
    "control", "control", "control", "control",
    "experiment", "experiment", "experiment", "experiment"
  ),
  Metadata_batch = c("a", "a", "b", "b", "a", "a", "b", "b"),
  AreaShape_Area = c(10, 12, 15, 16, 8, 8, 7, 7)
)
matric::get_annotation(population, annotation_prefix = "Metadata_")
}
