% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{preprocess_data}
\alias{preprocess_data}
\title{Preprocess data.
\code{preprocess_data} preprocesses data.}
\usage{
preprocess_data(population, annotation_prefix = "Metadata_")
}
\arguments{
\item{population}{data.frame with annotations (a.k.a. metadata) and
observation variables.}

\item{annotation_prefix}{optional character string specifying prefix for
annotation columns (e.g. \code{"Metadata_"} (default)).}
}
\value{
data.frame after preprocessing.
}
\description{
Preprocess data.
\code{preprocess_data} preprocesses data.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  AreaShape_Area = c(10, 12, 15, 16, 8, 8, 7, 7),
  AreaShape_Compactness = c(10, 12, NA, 16, 8, 8, 7, 7)
)
matric::drop_annotation(population, annotation_prefix = "Metadata_")
}
