% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_calculate.R
\name{sim_calculate_ij}
\alias{sim_calculate_ij}
\title{Calculate similarities given pairs of rows}
\usage{
sim_calculate_ij(
  population,
  index,
  method = NULL,
  annotation_prefix = "Metadata_",
  ...
)
}
\arguments{
\item{population}{data.frame with annotations (a.k.a. metadata) and
observation variables.}

\item{index}{data.frame with at least two columns \code{id1} and
\code{id2} specifying rows of \code{population}, and an optional attribute
\code{metric_metadata$method}, which is a character string specifying
implemented. Preserve the diagonal entries when constructing \code{index}}

\item{method}{optional character string specifying method for
to calculate similarity. \code{method}, if specified, overrides
\code{attr(index, "metric_metadata")$method}.}

\item{annotation_prefix}{optional character string specifying prefix
for annotation columns.}

\item{...}{arguments passed downstream for parallel processing.}
}
\value{
data.frame which is the same as \code{index}, but with a new
column \code{sim} containing similarities, and with the diagonals filtered out.
}
\description{
\code{sim_calculate_ij} calculates similarities given pairs of rows.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tribble(
  ~Metadata_group, ~x, ~y, ~z,
  1, -1, 5, -5,
  2, 0, 6, -4,
  3, 7, -4, 3,
  4, 14, -8, 6
)

n <- nrow(population)

index <-
  expand.grid(id1 = seq(n), id2 = seq(n), KEEP.OUT.ATTRS = FALSE)

matric::sim_calculate_ij(population, index, method = "cosine")

attr(index, "metric_metadata") <- list(method = "cosine")

matric::sim_calculate_ij(population, index)
}
