% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_construct-validate.R
\name{sim_restore}
\alias{sim_restore}
\title{Restorer for \code{matric_sim} S3 class.}
\usage{
sim_restore(x, x_attributes)
}
\arguments{
\item{x}{object to preserve.}

\item{x_attributes}{list of attributes of class \code{matric_sim}.}
}
\value{
Object of class \code{matric_sim} if \code{x} is a valid object of
that class
}
\description{
\code{restore} restores the attributes of class \code{matric_sim}.
}
\details{
This is a workaround until tibble inheritance improves

https://github.com/tidyverse/tibble/issues/275
https://adv-r.hadley.nz/s3.html#inheritance.

https://github.com/tidyverse/dplyr/issues/5480#issuecomment-682620522
"dplyr is not really ready for extension in this way"

These are some of the \code{dplyr} verbs that will necessitate restoration:
\itemize{
\item \code{summarise}
\item \code{group_by}
}

There are likely more!
}
\examples{

sim_df <-
  matric::sim_new(
    data.frame(id1 = 1, id2 = 2, sim = 1),
    data.frame(id = c(1, 2), Metadata_group = c("a", "b")),
    list(method = "pearson")
  )
sim_df_attr <- attributes(sim_df)
"matric_sim" \%in\% class(sim_df)
"matric_sim" \%in\% class(sim_df \%>\% dplyr::slice(1))
"matric_sim" \%in\%
  class(
    sim_df \%>\%
      dplyr::group_by(id1, id2) \%>\%
      dplyr::summarize(sim = mean(sim), .groups = "keep")
  )

"matric_sim" \%in\%
  class(
    sim_df \%>\%
      dplyr::group_by(id1, id2) \%>\%
      dplyr::summarize(sim = mean(sim), .groups = "keep") \%>\%
      matric::sim_restore(sim_df_attr)
  )
}
