% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowLogSumExps.R
\name{rowLogSumExps}
\alias{rowLogSumExps}
\alias{colLogSumExps}
\title{Accurately computes the logarithm of the sum of exponentials across rows or
columns}
\usage{
rowLogSumExps(lx, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(lx), ...)

colLogSumExps(lx, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(lx), ...)
}
\arguments{
\item{lx}{A \code{\link[base]{numeric}} NxK \code{\link[base]{matrix}}.
Typically \code{lx} are \eqn{log(x)} values.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.  \emph{Comment:} The reason for this argument
being named with a period at the end is purely technical (we get a run-time
error if we try to name it \code{dim}).}

\item{...}{Not used.}
}
\value{
A \code{\link[base]{numeric}} \code{\link[base]{vector}} of length N
(K).
}
\description{
Accurately computes the logarithm of the sum of exponentials across rows or
columns.
}
\section{Benchmarking}{

These methods are implemented in native code and have been optimized for
speed and memory.
}

\seealso{
To calculate the same on vectors, \code{\link{logSumExp}}().
}
\author{
Native implementation by Henrik Bengtsson.  Original R code by
Nakayama ??? (Japan).
}
\keyword{array}
