% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.bivdph.R
\name{bivdph}
\alias{bivdph}
\title{Constructor function for bivariate discrete phase-type distributions}
\usage{
bivdph(alpha = NULL, S11 = NULL, S12 = NULL, S22 = NULL, dimensions = c(3, 3))
}
\arguments{
\item{alpha}{A probability vector.}

\item{S11}{A sub-transition matrix.}

\item{S12}{A matrix.}

\item{S22}{A sub-transition matrix.}

\item{dimensions}{The dimensions of the bivariate discrete phase-type 
(if no parameters are provided).}
}
\value{
An object of class \linkS4class{bivdph}.
}
\description{
Constructor function for bivariate discrete phase-type distributions
}
\examples{
bivdph(dimensions = c(3, 3))
S11 <- matrix(c(0.1, .5, .5, 0.1), 2, 2)
S12 <- matrix(c(.2, .3, .2, .1), 2, 2)
S22 <- matrix(c(0.2, 0, 0.1, 0.1), 2, 2)
bivdph(alpha = c(.5, .5), S11, S12, S22)
}
