% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.postestimation.R
\name{effects.matrixpls}
\alias{effects.matrixpls}
\title{Total, Direct, and Indirect Effects for matrixpls results}
\usage{
\method{effects}{matrixpls}(object, ...)
}
\arguments{
\item{object}{matrixpls estimation result object produced by the \code{\link{matrixpls}} function.}

\item{...}{All other arguments are ignored.}
}
\value{
A list with \code{Total}, \code{Direct}, and \code{Indirect} elements.
}
\description{
The \code{matrixpls} method for the standard generic function \code{effects} computes total, direct, 
and indirect effects for a matrixpls results according to the method described in Fox (1980).

Adapted from the \code{\link[sem]{effects}} function of the \code{sem} package
}
\references{
Fox, J. (1980) Effect analysis in structural equation models: Extensions and simplified methods of computation. \emph{Sociological Methods and Research}
9, 3--28.
}
\seealso{
Other post-estimation functions: \code{\link{ave}},
  \code{\link{cr}}, \code{\link{fitSummary}},
  \code{\link{fitted.matrixpls}}, \code{\link{gof}},
  \code{\link{htmt}}, \code{\link{loadings.matrixpls}},
  \code{\link{predict.matrixpls}}, \code{\link{r2}},
  \code{\link{residuals.matrixpls}}
}

