% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.blindfold.R
\name{q2}
\alias{q2}
\title{Q2	predictive relevance statistics}
\usage{
q2(object, originalData, predictedData)
}
\arguments{
\item{object}{matrixpls estimation result object produced by the \code{\link{matrixpls}} function.}

\item{originalData}{A matrix or a data.frame containing the original data.}

\item{predictedData}{A matrix or a data.frame containing the predicted data that are compared
against the original data to calculate the predictive relevance statistic.}
}
\value{
A list with \code{total}, \code{block}, and \code{indicator} elements containing
the Q2 predictive relevance statistics for the full dataset, for each indicator block, and
for each indicator
}
\description{
Calculates Q2 predictive relevance statistics based on matrixpls results and 
crossvalidated predictions.
}
\details{
The Q2 statistic is calculated as \code{1-sse/sso} where \code{sse} is the sum of 
squared prediction errors based on comparison of the \code{originalData} and 
\code{predictedData} and \code{sso} is based on prediction with mean.
}

