% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightSign.R
\name{weightSign}
\alias{weightSign}
\alias{weightSign.Wold1985}
\alias{weightSign.dominantIndicator}
\title{Sign ambiquity corrections}
\usage{
weightSign.Wold1985(W, S)

weightSign.dominantIndicator(W, S)
}
\arguments{
\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{S}{Covariance matrix of the data.}
}
\value{
\code{W} after sign correction.
}
\description{
Sign ambiquity corrections adjust the signs of the weights to satisfy a criterion.
}
\details{
Instead of fixing a weight to a particular value, composite variables are typically provided a
scale by standardization. This leads to sign indeterminacy because standardized weights \code{W}
and \code{-W} both satisfy the scalign constraint. The sing ambiquity corrections add additional
constraints that make

The sign indeterminacy
corrections should not be confused with sign chance corrections applied to boostrap samples 
(See \code{\link{signChange}}).
}
\section{Functions}{
\itemize{
\item \code{weightSign.Wold1985}: Adjust the signs of W so that the majority of the indicators are positively 
correlated with the composite as proposed by Wold (1985).

\item \code{weightSign.dominantIndicator}: Adjust the signs of W so that the first indicator of each composite has positive
weight.
}}

\references{
Wold, H. (1985). Partial Least Squares. In S. Kotz & N. L. Johnson (Eds.), Encyclopedia  of 
statistical sciences (Vol. 6, pp. 581–591). New York: Wiley.
}
\seealso{
\code{\link{matrixpls}};
}
